﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SqlServer.Management.Smo;
using System.Data.SqlClient;
using System.Data;

namespace SQLScripter
{
    class Program
    {
        static void Main(string[] args)
        {
            if (args.Length == 0)
            {
                Console.WriteLine("Syntax : SQLScripter.exe <Server> <Database Name> <Scripts Path> [t=Tables,v=Views, s=Stored Procedures, a=User Defined Aggregates, f=User Defined Functions, Empty=All]");
            }
            else
            {
                try
                {
                    string serverName = args[0];
                    string databaseName = args[1];
                    string path = args[2];
                    string sqlObjectTypes = "tvsaf";

                    if (args.Length == 4)
                        sqlObjectTypes = args[3];

                    char[] types = sqlObjectTypes.ToCharArray();

                    ScripterHelper s = new ScripterHelper(serverName, databaseName, path);

                    if (Array.IndexOf(types, 't') != -1)
                        s.ScriptTables();

                    if (Array.IndexOf(types, 'v') != -1)
                        s.ScriptViews();

                    if (Array.IndexOf(types, 's') != -1)
                        s.ScriptStoredProcedures();

                    if (Array.IndexOf(types, 'a') != -1)
                        s.ScriptUserDefinedAggregates();

                    if (Array.IndexOf(types, 'f') != -1)
                        s.ScriptUserDefinedFunctions();

                    s.SaveLastUpdate();

                    Console.WriteLine("Scripting Completed!");
                }
                catch (Exception ex)
                {
                    Console.WriteLine();
                    Console.WriteLine();
                    Console.WriteLine("Error :");
                    Console.WriteLine(ex.ToString());
                }
            }
        }
    }
}
