#ifndef _SYM_SERVER_H_
#define _SYM_SERVER_H_

#include <wtypes.h>
#pragma pack( push, before_imagehlp, 8 )
#include <imagehlp.h>
#pragma pack( pop, before_imagehlp )
#include <tchar.h>

#define GET_CALLER_ADDR( addr ) \
__asm{ \
      __asm push eax \
      __asm mov eax, dword ptr[ ebp + 4 ] \
      __asm mov addr, eax \
      __asm pop eax \
	};

class SymServer  
{
public:
	static  SymServer* Create();	
	virtual ~SymServer();
	
	HRESULT Init();
	void	GetStack(PDWORD pStackArray, const int nArraySize, int& nStackDepth);
	void	AddrToSym(const DWORD dwAddr, LPTSTR lpszSymbols, const int nSymLen);
	void	AddrToLine(const DWORD dwAddr, DWORD& dwLine);
	void	AddrToFile(const DWORD dwAddr, LPTSTR lpszFile, const int nFileLen);
	void	AddrToFunc(const DWORD dwAddr, LPTSTR lpszFunc, const int nFuncLen);
	void	AddrToModule(const DWORD dwAddr, LPTSTR lpszModule, const int nModuleLen);

protected:
	SymServer();

private:
	static bool		 m_bInit;
	static HANDLE	 m_hProcess;
	IMAGEHLP_LINE    m_line;
	PIMAGEHLP_SYMBOL m_pSymbol;
	IMAGEHLP_MODULE  m_module;
};

#endif // _SYM_SERVER_H_
