//-----------------------------------------------------------------------------
// Name: ThreadObject
// Description: base class that encapsulates a thread.
// Note: this file is used by mote then one project.
//		 do not add include to stdafx.h. Instead, set this file as not using precompiled header
//--------------------------------------------------------------------------------
#include "threadObject.h"
#include <process.h>

//----------------------------------------------------------------------------------
//						              constructor
//----------------------------------------------------------------------------------
ThreadObject::ThreadObject() :
	m_hThread(NULL),
	m_dwThreadId(0)
{

}

//----------------------------------------------------------------------------------
//						              destructor
//----------------------------------------------------------------------------------
ThreadObject::~ThreadObject()
{
	if (m_hThread)
		waitForExit(10);
}

//----------------------------------------------------------------------------------
// Name: Run
// Description: run the thread
// Params: none
// Return: void
//----------------------------------------------------------------------------------
HRESULT ThreadObject::run(LPVOID param /* = NULL */)
{
	m_hThread = CreateThread(NULL, 
							 0, 
							 threadFunc, 
							 (LPVOID)this, 
							 0, 
							 &m_dwThreadId);
	
	if (NULL == m_hThread)
		return (errno != S_OK ? errno : S_FALSE);

	return S_OK;
}

//----------------------------------------------------------------------------------
// Name: WaitForExit
// Description: run the thread
// Params: ulSeconds - num seconds to wait for thread to finish
// Return: void
//----------------------------------------------------------------------------------
void ThreadObject::waitForExit(ULONG ulSeconds /* = INFINITE */)
{
	ULONG ulMillisec =  (ulSeconds == INFINITE ? INFINITE : ulSeconds * 1000);
	
	WaitForSingleObject(m_hThread, ulMillisec);
	CloseHandle(m_hThread);
	m_hThread = NULL;
}


//----------------------------------------------------------------------------------
// Name: ThreadFunc
// Description: the static function which call the member method where the thread will run
//				(the thread runs in the method ThreadMemberFunc(), which should be implemented
//				in the class the inherits from this class)
// Params: none
// Return: void
//----------------------------------------------------------------------------------
DWORD WINAPI ThreadObject::threadFunc(LPVOID pThreadObj)
{
	ThreadObject* pObject = (ThreadObject*)pThreadObj;

	return pObject->threadMemberFunc();
}
