//-----------------------------------------------------------------------------
// Class name: LockData
// Class description: the class encapsulates the lock operation data. For example:
//		 the locking thread, handle to the locked object, the stack trace and the type of action (lock single object or multiple objects)
//--------------------------------------------------------------------------------
#include "LockData.h"

LockData::LockData() :
	m_dwThreadID(0),
	m_hObject(NULL),
	m_nAction(eLastAction)
{
	memset(m_dwStackTrace, 0, sizeof(m_dwStackTrace));
}

LockData::LockData(DWORD		dwThreadID,
				  HANDLE		hObject,
				  ActionEnum	nAction,
				  DWORD*		pdwStackTrace, 
				  int			nStackTraceDepth,
				  DWORD			dwCallerAddr) :
	m_dwThreadID(dwThreadID),
	m_hObject(hObject),
	m_nAction(nAction),
	m_dwCallerAddr(dwCallerAddr)
{
	memset(m_dwStackTrace, 0, sizeof(m_dwStackTrace));
	memcpy(m_dwStackTrace, pdwStackTrace, min(nStackTraceDepth, sizeof(m_dwStackTrace)/sizeof(m_dwStackTrace[0]))*sizeof(m_dwStackTrace[0]));
	m_dwStackTrace[sizeof(m_dwStackTrace)/sizeof(m_dwStackTrace[0])-1] = 0;
}

LockData::~LockData()
{

}
