/*
  Toont na een druk op de knop met leds een willekeurig aantal ogen van een dobbelsteen. 

  Code geschreven op 13 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int switchPin = 2;
const int linksonder = 3;
const int linksmidden = 4;
const int linksboven = 5;
const int midden = 6;
const int rechtsonder = 7;
const int rechtsmidden = 8;
const int rechtsboven = 9;
const int vertraging = 5000; // Bepaalt hoe lang de leds van de dobbelsteen aan blijven.
long randNumber;

void setup(){
  randomSeed(analogRead(0));
  for (int pinNumber = 3; pinNumber <= 9; pinNumber++) {
    pinMode(pinNumber, OUTPUT);
  }
  pinMode(switchPin, INPUT);
}

void Zes()
{
  digitalWrite(linksonder, HIGH);
  digitalWrite(linksmidden, HIGH);
  digitalWrite(linksboven, HIGH);
  digitalWrite(midden, LOW);
  digitalWrite(rechtsonder, HIGH);
  digitalWrite(rechtsmidden, HIGH);
  digitalWrite(rechtsboven, HIGH);
}

void Vijf()
{
  digitalWrite(linksonder, HIGH);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, HIGH);
  digitalWrite(midden, HIGH);
  digitalWrite(rechtsonder, HIGH);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, HIGH);
}

void Vier()
{
  digitalWrite(linksonder, HIGH);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, HIGH);
  digitalWrite(midden, LOW);
  digitalWrite(rechtsonder, HIGH);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, HIGH);
}

void Drie()
{
  digitalWrite(linksonder, HIGH);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, LOW);
  digitalWrite(midden, HIGH);
  digitalWrite(rechtsonder, LOW);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, HIGH);
}

void Twee()
{
  digitalWrite(linksonder, LOW);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, HIGH);
  digitalWrite(midden, LOW);
  digitalWrite(rechtsonder, HIGH);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, LOW);
}

void Een()
{
  digitalWrite(linksonder, LOW);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, LOW);
  digitalWrite(midden, HIGH);
  digitalWrite(rechtsonder, LOW);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, LOW);
}

void Nul()
{
  digitalWrite(linksonder, LOW);
  digitalWrite(linksmidden, LOW);
  digitalWrite(linksboven, LOW);
  digitalWrite(midden, LOW);
  digitalWrite(rechtsonder, LOW);
  digitalWrite(rechtsmidden, LOW);
  digitalWrite(rechtsboven, LOW);
}

void loop() {  

  if (digitalRead(switchPin) == HIGH){
    randNumber = random(1, 7);

    switch (randNumber) {
      case 1:
        Een();
        break;
      case 2:
        Twee();
        break;
      case 3:
        Drie();
        break;
      case 4:
        Vier();
        break;
      case 5:
        Vijf();
        break;
      case 6:
        Zes();
        break;
    }
  
    delay(vertraging);
    Nul();
  }
}

