/*
  Toont het looplicht van Kitt en laat de KnightRider-tune horen via een piezo-luidspreker. 

  Code geschreven op 1 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital, https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License, https://www.gnu.org/
*/

const int ledPin1 = 2;
const int ledPin2 = 3;
const int ledPin3 = 4;
const int ledPin4 = 5;
const int ledPin5 = 6;
const int ledPin6 = 7;
const int ledPin7 = 8;
const int ledPin8 = 9;
const int ledPin9 = 10;
const int piezoPin = 11;
const int noot1 = 233;
const int noot2 = 246;
const int noot3 = 261;
const int noot4 = 277;
const int noot5 = 293;
const int rust = 120; // Verander hiermee de snelheid
const int duur = 60; // Verander hiermee de toonlengte
const int melody1[] = {noot4, noot5, noot4, noot4, noot5, noot4, noot4, noot5, noot4, noot4, noot4, noot3, noot4, noot4, noot4};
const int melody2[] = {noot2, noot3, noot2, noot2, noot3, noot2, noot2, noot3, noot2, noot2, noot2, noot1, noot2, noot2, noot2};
const int leds[] = {ledPin1, ledPin2, ledPin3, ledPin4, ledPin5, ledPin6, ledPin7, ledPin8, ledPin9, ledPin8, ledPin7, ledPin6, ledPin5, ledPin4, ledPin3, ledPin2};

void flashLED(int led) {
  digitalWrite(led, HIGH);
  delay(rust);
  digitalWrite(led, LOW);
}

void playMelody(const int melody[], const int leds[], int duration) {
    tone(piezoPin,melody[0],duur);
    flashLED(leds[0]);    
    flashLED(leds[1]);    
    for (int j = 1; j < duration; j++) {
      tone(piezoPin, melody[j], duur);
      flashLED(leds[j+1]);
    }  
}

void setup() {
  for (int pinNumber = 2; pinNumber <= 11; pinNumber++) {
    pinMode(pinNumber, OUTPUT);
  }
}

void loop() {

  for (int i = 0; i <= 1; i++) {
    playMelody(melody1, leds, sizeof(melody1)/sizeof(int));
  }

  for (int i = 0; i <= 1; i++) {
    playMelody(melody2, leds, sizeof(melody2)/sizeof(int));
  }

}
