/*
  Regelt automatisch en traploos de snelheid van een ventilator, afhankelijk van de temperatuur. 

  Code geschreven op 29 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int ntcPin = A0;
const int pulsePin = 2;
const int fanPin = 3;
const int inputMin = 400;
const int inputMax = 600;
const int outputMin = 60;
const int outputMax = 255;
const int wachttijd = 1000;

void setup() {
  pinMode(pulsePin, OUTPUT);
  pinMode(fanPin, OUTPUT);
}

void loop() {
  digitalWrite(pulsePin, HIGH);
  int input = analogRead(ntcPin);
  digitalWrite(pulsePin, LOW);
  input = constrain(input, inputMin, inputMax);
  int snelheid = map(input, inputMin, inputMax, outputMin, outputMax);
  analogWrite(fanPin, snelheid);
  delay(wachttijd);
}
