/*
  Laat een boodschap in morsecode horen via een piezo-luidspreker. 

  Code geschreven op 30 juni 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

int switchstate = 0;
const int ledPin = 13;
const int piezoPin = 12;
const int switchPin = 2;
const int noot = 2000; // Verander hiermee de toonhoogte
const int puntlengte = 60; // Verander hiermee de snelheid
const int streeplengte = puntlengte * 3;
const int interval = puntlengte; 
const int letterinterval = puntlengte * 3;
const int woordinterval = puntlengte * 7;
const char boodschap[] = "HALLO WERELD";

void setup() 
{
  pinMode(piezoPin, OUTPUT);
  pinMode(ledPin, OUTPUT);
  pinMode(switchPin, INPUT);  
}
 
void loop()
{
switchstate = digitalRead(switchPin);
  if (switchstate == HIGH) {
    for (int jj = 0; jj < sizeof(boodschap) - 1; jj++) {
        char kk = boodschap[jj];
        convertToMorse(kk);
        delay(letterinterval);
    }
  }
}
 
void punt()
{
  // laat een punt horen
  tone(piezoPin, noot);
  digitalWrite(ledPin, HIGH);
  delay(puntlengte);
  noTone(piezoPin);
  digitalWrite(ledPin, LOW);
  delay(interval);
}
 
void streep()
{
  // laat een streep horen
  tone(piezoPin, noot);
  digitalWrite(ledPin, HIGH);
  delay(streeplengte);
  noTone(piezoPin);
  digitalWrite(ledPin, LOW);
  delay(interval);
}
 
void convertToMorse(char letter)
{
  switch(letter)
  {
  case 'A':
    punt();
    streep();
    break;

  case 'B':
    streep();
    punt();
    punt();
    punt();
    break;

  case 'C':
    streep();
    punt();
    streep();
    punt();
    break;

  case 'D':
    streep();
    punt();
    punt();
    break;

  case 'E':
    punt();
    break; 

  case 'F':
    punt();
    punt();
    streep();
    punt();
    break;

  case 'G':
    streep();
    streep();
    punt();
    break;

  case 'H':
    punt();
    punt();
    punt();
    punt();
    break;

  case 'I':
    punt();
    punt();
    break;

  case 'J':
    punt();
    streep();
    streep();
    streep();
    break;

  case 'K':
    streep();
    punt();
    streep();
    break;

  case 'L':
    punt();
    streep();
    punt();
    punt();
    break;

  case 'M':
    streep();
    streep();
    break;

  case 'N':
    streep();
    punt();
    break;
    
  case 'O':
    streep();
    streep();
    streep();
    break;

  case 'P':
    punt();
    streep();
    streep();
    punt();
    break;

  case 'Q':
    streep();
    streep();
    punt();
    streep();
    break;

  case 'R':
    punt();
    streep();
    punt();
    break;

  case 'S':
    punt();
    punt();
    punt();
    break;

  case 'T':
    streep();
    break; 

  case 'U':
    punt();
    punt();
    streep();
    break;

  case 'V':
    punt();
    punt();
    punt();
    streep();
    break;

  case 'W':
    punt();
    streep();
    streep();
    break;

  case 'X':
    streep();
    punt();
    punt();
    streep();
    break;

  case 'Y':
    streep();
    punt();
    streep();
    streep();
    break;

  case 'Z':
    streep();
    streep();
    punt();
    punt();
    break;
    
  case ' ':
    delay(woordinterval);
    break; 
  }
}
