/*
  Maak een eenvoudig keyboard van de Arduino, met een bereik van van C4 tot C5. 

  Code geschreven op 21 juni 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int piezoPin = 2;
const int notes[] = {261, 293, 329, 349, 391, 440, 493, 523}; // Zie https://en.wikipedia.org/wiki/Piano_key_frequencies
int switchstates[] = {0, 0, 0, 0, 0, 0, 0, 0};

void setup() {
  pinMode(piezoPin, OUTPUT);
  for (int pinNumber = 3; pinNumber <= 10; pinNumber++) {
    pinMode(pinNumber, INPUT);
  }
}

void loop() {
    for (int switchNumber = 0; switchNumber <=7; switchNumber++) {
      switchstates[switchNumber] = digitalRead(switchNumber + 3);
      
    }
  
    if (switchstates[0] == HIGH) {
      tone(piezoPin, notes[0]);
    }
    else if (switchstates[1] == HIGH) {
      tone(piezoPin, notes[1]);
    }
    else if (switchstates[2] == HIGH) {
      tone(piezoPin, notes[2]);
    }
    else if (switchstates[3] == HIGH) {
      tone(piezoPin, notes[3]);
    }
    else if (switchstates[4] == HIGH) {
      tone(piezoPin, notes[4]);
    }
    else if (switchstates[5] == HIGH) {
      tone(piezoPin, notes[5]);
    }
    else if (switchstates[6] == HIGH) {
      tone(piezoPin, notes[6]);
    }
    else if (switchstates[7] == HIGH) {
      tone(piezoPin, notes[7]);
    }
    else {
      noTone(piezoPin);
    }
}

