/*
  Toont in een geleidelijk verlopend patroon alle primaire en secundaire kleuren van een rgb-led. 

  Code geschreven op 18 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int ledRood = 3;
const int ledGroen = 5;
const int ledBlauw = 6;
const int interval1 = 100; // Bepaal hier de snelheid waarmee de kleuren veranderen.
const int interval2 = 10000; // Bepaal hier hoelang de kleuren blijven staan.

void setup() {

}

void verschuifKleurOmhoog(int kleur) {
  delay(interval2);

  for (int i = 0; i <= 255; i++){
    analogWrite(kleur, i);
    delay(interval1);
  } 
}

void verschuifKleurOmlaag(int kleur) {
  delay(interval2);

  for (int i = 255; i >= 0; i--){
    analogWrite(kleur, i);
    delay(interval1);
  } 
}

void loop() {

  // we beginnen met rood
  analogWrite(ledRood, 255);
  analogWrite(ledGroen, 0);
  analogWrite(ledBlauw, 0);

  // van rood naar geel
  verschuifKleurOmhoog(ledGroen);

  // van geel naar groen
  verschuifKleurOmlaag(ledRood);

  // van groen naar cyaan
  verschuifKleurOmhoog(ledBlauw);

  // van cyaan naar blauw
  verschuifKleurOmlaag(ledGroen);

  // van blauw naar magenta
  verschuifKleurOmhoog(ledRood);

  // van magenta naar rood
  verschuifKleurOmlaag(ledBlauw);

}
