/*
  Toont na een druk op een van de vier knoppen de bijbehorende led en laat kort een toon horen via de piezo-luidspreker. 

  Code geschreven op 13 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int groen = 2;
const int geel = 3;
const int rood = 4;
const int blauw = 5;
const int piezoPin = 13;
const int switchGroen = 6;
const int switchGeel = 7;
const int switchRood = 8;
const int switchBlauw = 9;
const int toonhoogte = 500;
const int toonlengte = 1000;
const int brandduur = 5000;

void setup() 
{
  for (int pinNumber = 2; pinNumber <= 5; pinNumber++) {
    pinMode(pinNumber, OUTPUT);
  }
  for (int pinNumber = 6; pinNumber <= 9; pinNumber++) {
    pinMode(pinNumber, INPUT);
  }
  pinMode(piezoPin, OUTPUT);
}

void ledAan(int led)
{
  digitalWrite(led, HIGH);
  tone(piezoPin, toonhoogte, toonlengte);
  delay(brandduur);
  digitalWrite(led, LOW);
}
 
void loop()
{
  if (digitalRead(switchGroen) == HIGH){
    ledAan(groen);
  }
  else if (digitalRead(switchGeel) == HIGH){
    ledAan(geel);
  }
  else if (digitalRead(switchRood) == HIGH){
    ledAan(rood);
  }
  else if (digitalRead(switchBlauw) == HIGH){
    ledAan(blauw);
  }
}

