/*
  Laat een led branden als het donker wordt en zet de led weer uit als het licht genoeg is. 

  Code geschreven op 6 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital, https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License, https://www.gnu.org/
*/

const int ledPin = 12;
const int ldrPin = A0;
int value = 0;
int drempelwaarde = 250;
int hysterese = 25;

# define licht 1
# define donker 0

int situatie = licht;

void setup() 
{
  pinMode(ledPin, OUTPUT);
  pinMode(ldrPin, INPUT);
  Serial.begin(9600); 
}
 
void loop()
{
  value = analogRead(ldrPin);
  Serial.print(value);
  Serial.println();

  if (situatie == licht && value < drempelwaarde) {
    digitalWrite(ledPin, HIGH); 
    situatie = donker;
  }

  else if (situatie == donker && value > drempelwaarde + hysterese) {
    digitalWrite(ledPin, LOW); 
    situatie = licht;
  }

  delay(1000);
}

