/*
  Simuleert een tweede flitser bij detectie van een cameraflits. 

  Code geschreven op 5 augustus 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int ldrPin = A0;
const int ledPin = 13;
const int detectietijd = 1000; // De tijd in microseconden waarbinnen de flank van de gemeten lichtwaarde boven de drempel stijgt. Langer is gevoeliger, maar ook trager.
const int drempel = 10; // Stel hiermee de gevoeligheid in. Lager is gevoeliger, minimumwaarde is 2.
const int flitstijd = 100; // Duur van de slave-flits in milliseconden.

int value1 = 0;
int value2 = 0;

void setup() 
{
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600); 
}
 
void loop()
{
  value1 = analogRead(ldrPin);
  delayMicroseconds(detectietijd);
  value2 = analogRead(ldrPin);
  if (value2 - value1 >= drempel) {
    digitalWrite(ledPin, HIGH);
    delay(flitstijd);
    digitalWrite(ledPin, LOW);
    Serial.print("value1: ");
    Serial.print(value1);
    Serial.println();
    Serial.print("value2: ");
    Serial.print(value2);
    Serial.println();
  }
}



