/*
  Simuleert met een led een trappenhuisverlichting die langer brandt door langer op een knop te drukken. 

  Code geschreven op 4 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

int switchstate = 0;
const int ledPin = 12; 
const int switchPin = 6; 
const int langdrukken = 1000; // Bepaal hiermee hoe lang de knop moet worden ingedrukt om te verlengen.
const int standaardtijd = 5000; // Stel hiermee de tijd in dat de led normaal brandt.
const int langetijd = 20000; // Stel hiermee de langere periode in.

void setup() {
  pinMode(switchPin, INPUT);
  pinMode(ledPin, OUTPUT);
}

void loop() {
  switchstate = digitalRead(switchPin);
  if (switchstate == LOW) {
    digitalWrite(ledPin, LOW);
  }
  else {
    digitalWrite(ledPin, HIGH);
    delay(langdrukken); // Wacht om te zien of de knop nog steeds wordt ingedrukt, verleng de tijd als dat zo is.
    switchstate = digitalRead(switchPin);
    if (switchstate == LOW) {
      delay(standaardtijd - langdrukken);
    }
    else {
      delay(langetijd - langdrukken);
    }
  }
}

