/*
  Regel met een potmeter de snelheid van een ventilator. 

  Code geschreven op 29 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int potmeterPin = A0;
const int fanPin = 3;
const int inputMin = 0;
const int inputMax = 900;
const int outputMin = 60;
const int outputMax = 255;

void setup() {
  pinMode(fanPin, OUTPUT);
}

void loop() {
  int input = analogRead(potmeterPin);
  input = constrain(input, inputMin, inputMax);
  int snelheid = map(input, inputMin, inputMax, outputMin, outputMax);
  analogWrite(fanPin, snelheid);
}
