/*
  Trekt bij het indrukken van de eerste knop een willekeurig bingo-getal en geeft dat weer via twee rijen leds (tientallen en eenheden).
  Laat tevens bij elke keer dat de knop wordt ingedrukt een pieptoon horen uit een piezo-luidspreker. Als alle getallen zijn gevallen, stopt het
  programma totdat het wordt gereset met de tweede drukknop voor een nieuwe ronde.

  Code geschreven op 8 augustus 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int switchPin = 2;
const int piezoPin = 3;
const int toonhoogte = 500;
const int vertraging = 500; // kortste tijd in milliseconden tussen twee trekkingen (voorkomt dat het indrukken van de schakelaar vaker dan een keer wordt geteld).
const int aantalNummers = 75;
int bingoRij[aantalNummers];
int trekking = 0;

void willekeurigeRij() {
  int gekozen[aantalNummers];

  for (int i = 0; i < aantalNummers; i++) {
    gekozen[i] = 0;
  }
  
  for (int i = 0; i < aantalNummers; i++) {
    int willekeurig = random(aantalNummers - i);
    for(int j = 0; j <= willekeurig; j++) {
      willekeurig += gekozen[j];
    }
    gekozen[willekeurig] = 1;
    bingoRij[i] = willekeurig + 1;
  }
}

void Tientallen(int tiental) {
  for (int i = 13; i <= tiental; i++) {
    digitalWrite(i, HIGH);
  }
  for (int i = tiental + 1; i <= A5; i++) {
    digitalWrite(i, LOW);
  }
}

void Eenheden(int eenheid) {
  for (int i = 4; i <= eenheid; i++) {
    digitalWrite(i, HIGH);
  }
  for (int i = eenheid + 1; i <= 12; i++) {
    digitalWrite(i, LOW);
  }
}

void trekGetal() {
  int getal = bingoRij[trekking];
  int tiental = getal / 10;
  int eenheid = getal % 10;
  Serial.print(getal);
  Serial.print(" ");
  trekking++;
  while (digitalRead(switchPin) == HIGH) {
    delay(vertraging);
  }

  Tientallen(tiental + 12);
  Eenheden(eenheid + 3);
}

void setup() {
  randomSeed(analogRead(6));
  Serial.begin(9600); 
  for (int pinNumber = 3; pinNumber <= A5; pinNumber++) {
    pinMode(pinNumber, OUTPUT);
  }
  pinMode(switchPin, INPUT);
  willekeurigeRij();
}

void loop() {
  if (digitalRead(switchPin) == HIGH && trekking < aantalNummers) {
    tone(piezoPin, toonhoogte, vertraging);
    trekGetal();
  }
}

