/*
  Simuleert met twee gele leds het flakkeren van een kaarsvlam. 

  Code geschreven op 5 augustus 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int ledPin = 3;
const int max_stil = 10000; // Maximale tijd in milliseconden dat de led niet flakkert, langer is rustiger.
const int max_vertoning = 3; // Maximumaantal vertoningen van een patroon.
const int min_helderheid = 50; // Donkerste waarde van het flakkeren (maximaal 255).
const int max_helderheid = 150; // Lichtste waarde van het flakkeren (maximaal 255).
const int min_vertraging = 2; // Hoogste snelheid van het flakkeren (lager is sneller).
const int max_vertraging = 10; // Laagste snelheid van het flakkeren (lager is sneller).
long stil; // Tijd dat de vlam 'stilstaat'.
long vertoning; // Aantal vertoningen van het patroon.
long helderheid; // Helderheid van het flakkeren.
long vertraging; // Snelheid van het flakkeren.

void setup(){
  randomSeed(analogRead(0));
  pinMode(ledPin, OUTPUT);
}

void loop() {
  stil = random(max_stil); 
  vertoning = random(max_vertoning);
  helderheid = random(min_helderheid, max_helderheid);
  vertraging = random(min_vertraging, max_vertraging);

  digitalWrite(ledPin, HIGH);
  delay(stil);
  
  for (int i = 0; i < vertoning; i++) {
    for (int j = 255; j >= helderheid; j--) {
      analogWrite(ledPin, j);
      delay(vertraging);
    }

    for (int j = helderheid; j <= 255; j++) {
      analogWrite(ledPin, j);
      delay(vertraging);
    }
  }
}

