/*
  Regel via twee knoppen de lichtsterkte van een led. 

  Code geschreven op 26 juli 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int switchPinUp = 2;
const int switchPinDown = 3;
const int ledPin = 5;
const int vertraging = 10; // Regel hiermee de snelheid van hoger- en lager zetten.
int helderheid = 0;

void setup() 
{
  pinMode(ledPin, OUTPUT);
  pinMode(switchPinUp, INPUT);
  pinMode(switchPinDown, INPUT);
}
 
void loop()
{
  if (digitalRead(switchPinUp) == HIGH && helderheid < 255) {
    helderheid++;
  }
  else if (digitalRead(switchPinDown) == HIGH && helderheid > 0) {
    helderheid--;
  }
  analogWrite(ledPin, helderheid); // Hier gebruiken we pulsbreedtemodulatie om de helderheid van de led in te stellen.
  delay(vertraging);
}

