/*
  Toont een groene led na het binnen de gestelde tijd invoeren van de juiste pincode. 
  Blokkeert en toont gedurende een periode een rode led als een onjuiste code is ingevoerd.

  Code geschreven op 1 augustus 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int piezoPin = 12;
const int ledPinRood = A0;
const int ledPinGroen = A1;
const int wachttijd = 200; // Wachttijd bij indrukken schakelaar, tevens de lengte van de pieptoon. Verhoog waarde bij slechte schakelaars.
const int pinCijfer_1 = 3; 
const int pinCijfer_2 = 4;
const int pinCijfer_3 = 5;
const int pinCijfer_4 = 6;
const int resetTijd = 5000; // Bepaal hiermee de tijd in milliseconden waarbinnen de volledige code moet zijn ingevoerd.
const long blokkeerTijd = 300000; // Tijd in milliseconden dat de schakeling blokkeert na verkeerde code.
const int tijdOpen = 5000; // Tijd in milliseconden na correcte code.

int drukknop = 0;
int teller = 0;
int timer = 0;
int alJuist = 0;

void setup() {
  for (int pinNumber = 2; pinNumber <= 11; pinNumber++) {
    pinMode(pinNumber, INPUT);
  }
  pinMode(ledPinRood, OUTPUT);
  pinMode(ledPinGroen, OUTPUT);
  pinMode(piezoPin, OUTPUT);
}

void blokkeertimeOut(long mSec) {
  unsigned long startMillis = millis();
  while (millis() - startMillis < mSec);
}

void reset() {
  timer = 0;
  teller = 0;
  alJuist = 0;
  drukknop = 0;
}

void blokkeren() {
  reset();
  digitalWrite(ledPinRood, HIGH);
  blokkeertimeOut(blokkeerTijd);
  digitalWrite(ledPinRood, LOW);
}

void openen() {
  reset();
  digitalWrite(ledPinGroen, HIGH);
  delay(tijdOpen);
  digitalWrite(ledPinGroen, LOW);  
}

void loop() {

  for (int i = 2; i <= 11; i++) {
    if (digitalRead(i) == HIGH) {
      tone(piezoPin, 500, wachttijd);
      drukknop = i - 2;
      teller++;
      while (digitalRead(i) == HIGH) {
        delay(wachttijd);
      }
    }
  }

  if (drukknop == pinCijfer_1 && teller == 1 && alJuist == 0) {
    alJuist = 1;
  }
  else if (drukknop == pinCijfer_2 && teller == 2 && alJuist == 1) {
    alJuist = 2;
  }
  else if (drukknop == pinCijfer_3 && teller == 3 && alJuist == 2) {
    alJuist = 3;
  }
  else if (drukknop == pinCijfer_4 && teller == 4 && alJuist == 3) {
    openen();
  }
  else if (teller == 4) {
    blokkeren();
  }

  if (teller > 0) {
    timer++;
  }

  if (timer > resetTijd) {
    reset();
  }

  delay(1);

}
