/*
  Laat een alarm horen uit een piezo-luidspreker zodra beweging wordt gedetecteerd. 

  Code geschreven op 5 augustus 2016 door Koen Vervloesem en Martijn Overman voor Reshift Digital https://reshift.nl/ 

  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int tiltPin = 3;
const int piezoPin = 2;
const int toonLaag = 1000; // Bepaalt de laagste toon van het alarm.
const int toonHoog = 2000; // Bepaalt de hoogste toon van het alarm.
const int tijdsinterval = 200; // Bepaalt de snelheid, lager is sneller.
const int lengte = 10; // Bepaalt de duur van het alarm.

void setup()
{
   pinMode(tiltPin, INPUT);
   pinMode(piezoPin, OUTPUT);
}

void loop(){
  int switchstate = digitalRead(tiltPin);
  if (switchstate == LOW){
    for (int i = 0; i < lengte; i++){
      for (int toon=toonHoog; toon >= toonLaag; toon--){
        tone(piezoPin, toon);
        delayMicroseconds(tijdsinterval);
      } 
    }
  }
  else{
    noTone(piezoPin);
  }
}
