/*
 Piano opdracht bij ArduinoNano voor kinderen

  Code geschreven op 24 december 2016 door Maas voor Reshift Digital https://reshift.nl/ 
  ___  ___                                              
|  \/  |                                              
| .  . | __ _  __ _  __ _  __ _  __ _  __ _  __ _ ___ 
| |\/| |/ _` |/ _` |/ _` |/ _` |/ _` |/ _` |/ _` / __|
| |  | | (_| | (_| | (_| | (_| | (_| | (_| | (_| \__ \
\_|  |_/\__,_|\__,_|\__,_|\__,_|\__,_|\__,_|\__,_|___/
                                                      
                                                      
  Deze software mag worden verspreid onder de bepalingen van de GNU General Public License https://www.gnu.org/
*/

const int piezoPin = 3;
const int notes[] = {329, 293, 261}; // Zie https://en.wikipedia.org/wiki/Piano_key_frequencies
int switchstates[] = {0, 0, 0};

void setup() {
  pinMode(piezoPin, OUTPUT);
  for (int pinNumber = 6; pinNumber <= 8; pinNumber++) {
    pinMode(pinNumber, INPUT);
  }
}

void loop() {
     switchstates[0] = digitalRead(6);
     switchstates[1] = digitalRead(7);
     switchstates[2] = digitalRead(8);
  
    if (switchstates[0] == HIGH) {
      tone(piezoPin, notes[0]);
    }
    else if (switchstates[1] == HIGH) {
      tone(piezoPin, notes[1]);
    }
    else if (switchstates[2] == HIGH) {
      tone(piezoPin, notes[2]);
    }
    else {
      noTone(piezoPin);
    }
}

