#ifndef _DDA_MGR_H_
#define _DDA_MGR_H_

#pragma warning (disable : 4786)

#include <wtypes.h>
#include <list>
#include "LocksLoggerThread.h"

using namespace std;

class DDAMgr  
{
public:
	enum StateEnum { eFirstState,
					 eStart = eFirstState,
					 eStop,
					 eAnalyze,
					 eError,
					 eLastState };

public:
	static DDAMgr* getInstance() { static DDAMgr instance; return &instance; }
	virtual ~DDAMgr();

	// actions
	HRESULT	start();
	HRESULT	stop();
	HRESULT	analyze();
	HRESULT	terminate();

	// get
	StateEnum		         getState()				const { return m_nState; }
	const LockSequenceList&  getDeadlockSeqList()	const { return m_deadlockSeqList; }

protected:
	DDAMgr();
	DDAMgr(const DDAMgr& other) {}
	const DDAMgr& operator = (const DDAMgr& other) { return *this; }

private:
	StateEnum			m_nState;
	LockSequenceList	m_deadlockSeqList;
};

#endif // _DDA_MGR_H_
