#include "LockSequenceAnalyzer.h"
#include <algorithm>

LockSequenceAnalyzer::LockSequenceAnalyzer()
{

}

LockSequenceAnalyzer::~LockSequenceAnalyzer()
{

}

void LockSequenceAnalyzer::analyze(const LockSequenceList& lockSeqList, LockSequenceList& deadlockSeqList) const
{
	// loop over lock sequence list and search for cycles (cycle represnts potential deadlock)
	for (LockSequenceList::const_iterator lockSeqListIter = lockSeqList.begin();
		 lockSeqListIter != lockSeqList.end();
		 lockSeqListIter++)
	{
		LockSequence::const_iterator lockSeqIter = lockSeqListIter->begin();
		for (lockSeqIter++;
			 lockSeqIter != (*lockSeqListIter).end();
			 lockSeqIter++)
		{
			if (true == findCycle(*lockSeqListIter, lockSeqIter, *lockSeqListIter, lockSeqListIter->begin(), lockSeqList, deadlockSeqList))
			{
				return;
			}
		}
	}
}

bool LockSequenceAnalyzer::findCycle(const LockSequence& firstSeq, const LockSequence::const_iterator firstSeqIter,
									 const LockSequence& currSeq,  LockSequence::const_iterator currSeqIter, 
									 const LockSequenceList& lockSeqList, LockSequenceList& deadlockSeqList) const
{
	LockSequence::const_iterator findCurrSeqIter, findFirstSeqIter;
	LockSequence::const_iterator originCurrSeqIter = currSeqIter;

	for (currSeqIter++;
		 currSeqIter != currSeq.end();
		 currSeqIter++)
	{
		// loop over all sequences
		for (LockSequenceList::const_iterator lockSeqListIter = lockSeqList.begin();
			 lockSeqListIter != lockSeqList.end();
			 lockSeqListIter++)
		{
			if ((*lockSeqListIter) != currSeq && (*lockSeqListIter) != firstSeq)
			{
				// find possible begining of cycle
				findCurrSeqIter = find((*lockSeqListIter).begin(), (*lockSeqListIter).end(), (*currSeqIter)); 
				if (findCurrSeqIter != (*lockSeqListIter).end())
				{
					// search for possible close of cycle
					LockSequence::const_iterator lockSeqIter = findCurrSeqIter;
					for (lockSeqIter++;
						 lockSeqIter != (*lockSeqListIter).end();
						 lockSeqIter++)
					{
						findFirstSeqIter = find(firstSeq.begin(), firstSeqIter, (*lockSeqIter)); 
						if (findFirstSeqIter != firstSeqIter)
						{
							// a cycle was found
							// TODO: copy from originCurrSeqIter to currSeqIter
							LockSequence deadlockSeq1, deadlockSeq2;
							deadlockSeq1.insert(deadlockSeq1.begin(), originCurrSeqIter, ++currSeqIter);
							//deadlockSeq.push_back(*findCurrSeqIter);
							// TODO: copy from findCurrSeqIter to lockSeqIter
							//deadlockSeq.push_back(*findFirstSeqIter);
							deadlockSeq2.insert(deadlockSeq2.begin(), findCurrSeqIter, ++lockSeqIter);
							deadlockSeqList.push_back(deadlockSeq1);
							deadlockSeqList.push_back(deadlockSeq2);
							return true;
						}
						else
						{
							bool bFindCycle = findCycle(firstSeq, firstSeqIter, *lockSeqListIter, findCurrSeqIter, lockSeqList, deadlockSeqList);
							if (true == bFindCycle)
							{
								// TODO: copy from originCurrSeqIter to currSeqIter
								//deadlockSeq.push_back(*findCurrSeqIter);
								LockSequence deadlockSeq;
								deadlockSeq.insert(deadlockSeq.begin(), originCurrSeqIter, ++currSeqIter);
								deadlockSeqList.push_back(deadlockSeq);
								return true;
							}
						}
					}
				}
			}
		}
	}	
	
	return false;
}
