#ifndef _LOCK_H_
#define _LOCK_H_

#include <wtypes.h>
#include <winNT.h>

#define STACK_TRACE_MAX_DEPTH 10

class LockData
{
public:
	enum ActionEnum { eFirstAction,
					  eCreateAction = eFirstAction,
					  eLockAction,
					  eUnlockAction,
					  eSetEventAction,
					  eResetEventAction,
					  eLastAction };

	LockData();
	LockData(const LockData& otherData) { *this = otherData; }
	LockData(DWORD		dwThreadID,
			 HANDLE		hObject,
			 ActionEnum nAction,
			 DWORD*		pdwStackTrace, 
			 int		nStackTraceDepth,
			 DWORD		dwCallerAddr);
	virtual ~LockData();

	bool operator == (const LockData& otherLock)			const { return (this->m_hObject == otherLock.m_hObject); }
	
	DWORD		getThreadID()								const { return m_dwThreadID; } 
	HANDLE		getHandle()									const { return m_hObject; }
	ActionEnum	getAction()									const { return m_nAction; }
	void		getStack(PDWORD pStack, const int nSize)	const { memcpy(pStack, m_dwStackTrace, min(nSize, sizeof(m_dwStackTrace))); }
	DWORD		getCallerAddr()	 							const { return m_dwCallerAddr; }

private:
	DWORD		m_dwThreadID;
	HANDLE		m_hObject;
	DWORD		m_dwStackTrace[STACK_TRACE_MAX_DEPTH];
	DWORD		m_dwCallerAddr;
	ActionEnum	m_nAction;
};

#endif // _LOCK_H_
