#ifndef _DDA_VIEW_THREAD_H_
#define _DDA_VIEW_THREAD_H_

#include <wtypes.h>
#include "DDAMgr.h"
#include "threadObject.h"

class DDAViewThread : public ThreadObject 
{
public:
	static DDAViewThread* getInstance() { static DDAViewThread instance; return &instance; }
	virtual ~DDAViewThread();

	void update();
	void terminate();

protected:
	DDAViewThread();
	virtual DWORD threadMemberFunc();

	void    showResults() const;
	HRESULT showDlg() const;
	HRESULT	doAction(HWND hDlg);

private:
	static BOOL CALLBACK DialogProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

private:
	DDAMgr* m_pMgr;
};

#endif // _DDA_VIEW_THREAD_H_
