#include "LockSequenceBuilder.h"
#include <algorithm>


LockSequenceBuilder::LockSequenceBuilder()  :
	m_pLockSeqList(NULL),
	m_bUpdateLockSeqList(false)
{

}

LockSequenceBuilder::~LockSequenceBuilder()
{

}

void LockSequenceBuilder::Build(const ThreadID2LockDataListMap& thread2LockListMap, LockSequenceList& lockSeqList)
{
	m_pLockSeqList = &lockSeqList;

	// loop over all threads
	for (ThreadID2LockDataListMap::const_iterator mapIter = thread2LockListMap.begin();
		 mapIter != thread2LockListMap.end();
		 mapIter++)
	{

		m_currLockSeq.clear();

		const LockDataList& lockDataList = ((*mapIter).second);
		// loop over all locks
		for (LockDataList::const_iterator listIter = lockDataList.begin();
			 listIter != lockDataList.end();
			 listIter++)
		{
			const LockData& lockData = (*listIter);
			switch (lockData.getAction())
			{
			case (LockData::eLockAction):
				handleSingleLock(lockData);
				break;

			case (LockData::eUnlockAction):
				handleUnlock(lockData);
				break;

			default:
				// TODO - handle unexpected action ???!!!
				break;
			}
		}

		// call unlock with dummy data to update m_pLockSeqList
		LockData dummyLockData;
		handleUnlock(dummyLockData);
	}

	removeDuplications();
}

/*-----------------------------------------------------------------------
Name: handleSingleLock
Description: handle a single lock (such as WaitForSingleObject or EnterCriticalSection)
Parameters:  lockData - the lock data
------------------------------------------------------------------------*/
void LockSequenceBuilder::handleSingleLock(const LockData& lockData)
{
	LockSequence::iterator locSeqIter = find(m_currLockSeq.begin(), m_currLockSeq.end(), lockData); 
	
	// if data already exist in curr lock sequence do nothing (meaning - object was already locked)
	if (locSeqIter != m_currLockSeq.end())
	{
		return;
	}

	// data doesn't exist -  insert it
	m_bUpdateLockSeqList = true;
	m_currLockSeq.push_back(lockData);
}

/*-----------------------------------------------------------------------
Name: handleUnlock
Description: handle an unlock operation (such as ReleaseMutex or LeaveCriticalSection)
Parameters:  lockData - the lock data
------------------------------------------------------------------------*/
void LockSequenceBuilder::handleUnlock(const LockData& lockData)
{	
	// copy curr lock sequence
	if (m_currLockSeq.size() > 1 && true == m_bUpdateLockSeqList)
	{
		LockSequence lockSeq;
		lockSeq = m_currLockSeq;
		m_pLockSeqList->push_back(lockSeq);
		m_bUpdateLockSeqList = false;
	}
	
	m_currLockSeq.remove(lockData);
}

void LockSequenceBuilder::handleMultipleLocksWaitAll(const LockData& lockData)
{

}

void LockSequenceBuilder::handleMultipleLocksWaitSingle(const LockData& lockData)
{

}

void LockSequenceBuilder::removeDuplications()
{
	LockSequenceList::iterator erasedElemIter;

	// loop over lock sequence list and search for duplications
	for (LockSequenceList::iterator lockSeqIter1 = m_pLockSeqList->begin();
		 lockSeqIter1 != m_pLockSeqList->end();
		 lockSeqIter1++)
	{
		// loop over rest of lock sequence list
		for (LockSequenceList::iterator lockSeqIter2 = lockSeqIter1;
			 lockSeqIter2 != m_pLockSeqList->end();
			 lockSeqIter2++)
		{
			if (lockSeqIter1 == lockSeqIter2)
			{
				continue;
			}

			if ((*lockSeqIter1) == (*lockSeqIter2))
			{

				erasedElemIter = lockSeqIter2;
				lockSeqIter2--;
				m_pLockSeqList->erase(erasedElemIter);
			}
		}
	}
}