#ifndef _LOCK_SEQUENCE_BUILDER_H_
#define _LOCK_SEQUENCE_BUILDER_H_

#include "locksLoggerThread.h"

class LockSequenceBuilder  
{
public:
	LockSequenceBuilder();
	virtual ~LockSequenceBuilder();

	void Build(const ThreadID2LockDataListMap& thread2LockListMap, LockSequenceList& lockSeqList);

private:
	void handleSingleLock(const LockData& lockData);
	void handleMultipleLocksWaitAll(const LockData& lockData);
	void handleMultipleLocksWaitSingle(const LockData& lockData);
	void handleUnlock(const LockData& lockData);

	void removeDuplications();

private:
	LockSequenceList* m_pLockSeqList;
	LockSequence	  m_currLockSeq;
	bool			  m_bUpdateLockSeqList;
};

#endif // _LOCK_SEQUENCE_BUILDER_H_
