#ifndef _LOCKS_LOGGER_H_
#define _LOCKS_LOGGER_H_

#pragma warning (disable : 4786)

#include <wtypes.h>
#include <map>
#include <list>
#include "lockData.h"

using namespace std;

typedef list<LockData> LockDataList;
typedef list<LockData> LockSequence;
typedef list<LockSequence> LockSequenceList;
typedef map< DWORD, LockDataList >	ThreadID2LockDataListMap;
typedef map< HANDLE, HANDLE >		Obj2ObjMap;

#define	WM_LM_INIT_Q    WM_USER + 1
#define	WM_LM_IGNORE    WM_USER + 2
#define	WM_LM_LOCK		WM_USER + 3
#define	WM_LM_UNLOCK    WM_USER + 4
#define WM_LM_QUIT	    WM_USER + 5

class LocksLoggerThread  
{
public:
	static LocksLoggerThread* getInstance() { static LocksLoggerThread instance; return &instance; }
	virtual ~LocksLoggerThread();

	// actions
	HRESULT run();
	void	stop();
	
	// getters
	const   ThreadID2LockDataListMap& getThread2LockListMap()	const { return m_thread2LockListMap; }
	DWORD	getThreadID()										const { return m_dwThreadId; }

protected:
	LocksLoggerThread();
	
	// thread methods
	static	DWORD WINAPI threadFunc(LPVOID param);
	virtual DWORD threadMemberFunc();
	
	// actions
	void	addLockDataToLockList(const LockData& lockData);
	void	removeIgnoredObjects();

	static	DWORD WaitForSingleObject(HANDLE hObject, DWORD dwMilliseconds);

private:
	HANDLE m_hThread;
	DWORD  m_dwThreadId;
	bool   m_bRun;

	ThreadID2LockDataListMap m_thread2LockListMap;
	Obj2ObjMap				 m_ignoredObjMap;
};

#endif // _LOCKS_LOGGER_H_
