//-----------------------------------------------------------------------------
// File name: hookedFunctions
// Class description: the file implements the hook/unhook operations and the functions that replace the hooked functions
//--------------------------------------------------------------------------------
#include <iostream.h>
#include "hookedFunctions.h"
#include "BugslayerUtil.h"
#include "locksLoggerThread.h"
#include "symServer.h"

extern SymServer* g_pSymServer;


typedef DWORD  (WINAPI *WAITFORSINGLEOBJECTPROC)(HANDLE, DWORD);
typedef DWORD  (WINAPI *WAITFORMULTIPLEOBJECTSPROC)(DWORD, CONST HANDLE*, BOOL, DWORD); 
typedef BOOL   (WINAPI *RELEASEMUTEXPROC)(HANDLE);
typedef HANDLE (WINAPI *CREATEMUTEXPROC)(LPSECURITY_ATTRIBUTES, BOOL, LPCSTR);
typedef VOID   (WINAPI *INITCRITICSECPROC) (LPCRITICAL_SECTION);
typedef VOID   (WINAPI *ENTERCRITICSECPROC)(LPCRITICAL_SECTION);
typedef VOID   (WINAPI *LEAVECRITICSECPROC)(LPCRITICAL_SECTION);
typedef HANDLE (WINAPI *CREATEEVENTPROC)(LPSECURITY_ATTRIBUTES, BOOL, BOOL, LPCSTR);
typedef BOOL   (WINAPI *SETEVENTPROC)(HANDLE);
typedef BOOL   (WINAPI *RESETEVENTPROC)(HANDLE);

// ptr to original functions
WAITFORSINGLEOBJECTPROC		g_pfnOrigWaitForSingleObject = NULL;
WAITFORMULTIPLEOBJECTSPROC	g_pfnOrigWaitForMultipleObjects = NULL;
CREATEMUTEXPROC				g_pfnOrigCreateMutex = NULL;
RELEASEMUTEXPROC			g_pfnOrigReleaseMutex = NULL;
INITCRITICSECPROC			g_pfnOrigInitializeCriticalSection = NULL;
ENTERCRITICSECPROC			g_pfnOrigEnterCriticalSection = NULL;
LEAVECRITICSECPROC			g_pfnOrigLeaveCriticalSection = NULL;
CREATEEVENTPROC				g_pfnOrigCreateEvent = NULL;
SETEVENTPROC				g_pfnOrigSetEvent = NULL;
RESETEVENTPROC				g_pfnOrigResetEvent = NULL;

// prototypes of functions to be called instead of original functions
static DWORD	WINAPI MyWaitForSingleObject(IN HANDLE hHandle, IN DWORD dwMilliseconds);
static DWORD	WINAPI MyWaitForMultipleObjects(IN DWORD nCount, IN CONST HANDLE *lpHandles, IN BOOL bWaitAll, IN DWORD dwMilliseconds);
static HANDLE	WINAPI MyCreateMutex(IN LPSECURITY_ATTRIBUTES lpMutexAttributes, IN BOOL bInitialOwner, IN LPCSTR lpName);
static BOOL		WINAPI MyReleaseMutex(IN HANDLE hMutex);
static VOID     WINAPI MyInitializeCriticalSection(OUT LPCRITICAL_SECTION lpCriticalSection);
static VOID     WINAPI MyEnterCriticalSection(IN OUT LPCRITICAL_SECTION lpCriticalSection);
static VOID     WINAPI MyLeaveCriticalSection(IN OUT LPCRITICAL_SECTION lpCriticalSection);
static HANDLE	WINAPI MyCreateEvent(IN LPSECURITY_ATTRIBUTES lpEventAttributes, IN BOOL bManualReset, IN BOOL bInitialState, IN LPCSTR lpName);
static BOOL		WINAPI MySetEvent(IN HANDLE hEvent);
static BOOL		WINAPI MyResetEvent(IN HANDLE hEvent);

// add here any imported function you wish to hook
static HookedFunc hookedFuncArray[] = { HookedFunc("WaitForSingleObject",		(PROC)MyWaitForSingleObject,		(PROC*)&g_pfnOrigWaitForSingleObject,		"Kernel32.DLL"),
										HookedFunc("WaitForMultipleObjects",	(PROC)MyWaitForMultipleObjects,		(PROC*)&g_pfnOrigWaitForMultipleObjects,	"Kernel32.DLL"),
										HookedFunc("CreateMutexA",				(PROC)MyCreateMutex,				(PROC*)&g_pfnOrigCreateMutex,				"Kernel32.DLL"),
										HookedFunc("ReleaseMutex",				(PROC)MyReleaseMutex,				(PROC*)&g_pfnOrigReleaseMutex,				"Kernel32.DLL"),
										HookedFunc("InitializeCriticalSection",	(PROC)MyInitializeCriticalSection,	(PROC*)&g_pfnOrigInitializeCriticalSection,	"Kernel32.DLL"),
										HookedFunc("EnterCriticalSection",		(PROC)MyEnterCriticalSection,		(PROC*)&g_pfnOrigEnterCriticalSection,		"Kernel32.DLL"),
										HookedFunc("LeaveCriticalSection",		(PROC)MyLeaveCriticalSection,		(PROC*)&g_pfnOrigLeaveCriticalSection,		"Kernel32.DLL"),
										HookedFunc("CreateEventA",				(PROC)MyCreateEvent,				(PROC*)&g_pfnOrigCreateEvent,				"Kernel32.DLL"),
										HookedFunc("SetEvent",				    (PROC)MySetEvent,					(PROC*)&g_pfnOrigSetEvent,					"Kernel32.DLL"),
										HookedFunc("ResetEvent",				(PROC)MyResetEvent,					(PROC*)&g_pfnOrigResetEvent,				"Kernel32.DLL") };

DWORD WINAPI MyWaitForSingleObject(IN HANDLE hHandle, IN DWORD dwMilliseconds)
{
	DWORD dwStackTrace[10] = { 0 };
	int   nStackDepth = 0;
	DWORD dwCallerAddr = 0;

	g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
	GET_CALLER_ADDR(dwCallerAddr);

	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										hHandle,
										LockData::eLockAction,
										dwStackTrace,
										nStackDepth,
										dwCallerAddr);

	//cout << "calling MyWaitForSingleObject" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_LOCK, (WPARAM)pLockData, (LPARAM)NULL);

	return g_pfnOrigWaitForSingleObject(hHandle, dwMilliseconds);
}

DWORD WINAPI MyWaitForMultipleObjects(IN DWORD nCount, IN CONST HANDLE *lpHandles, IN BOOL bWaitAll, IN DWORD dwMilliseconds)
{
	DWORD dwStackTrace[10] = { 0 };
	int   nStackDepth = 0;
	DWORD dwCallerAddr = 0;

	g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
	GET_CALLER_ADDR(dwCallerAddr);

	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										NULL, // to change ???!!!
										LockData::eLockAction,
										dwStackTrace,
										nStackDepth,
										dwCallerAddr);

	//cout << "calling MyWaitForMultipleObjects" << endl;
	//PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_LOCK, (WPARAM)pLockData, (LPARAM)NULL);

	return g_pfnOrigWaitForMultipleObjects(nCount, lpHandles, bWaitAll, dwMilliseconds);
}

HANDLE WINAPI MyCreateMutex(IN LPSECURITY_ATTRIBUTES lpMutexAttributes, IN BOOL bInitialOwner, IN LPCSTR lpName)
{
	//cout << "calling MyCreateMutex" << endl;
	HANDLE hMutex =  g_pfnOrigCreateMutex(lpMutexAttributes, bInitialOwner, lpName);

	if (TRUE == bInitialOwner)
	{
		DWORD dwStackTrace[10] = { 0 };
		int   nStackDepth = 0;
		DWORD dwCallerAddr = 0;

		g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
		GET_CALLER_ADDR(dwCallerAddr);
		
		LockData*  pLockData = new LockData(GetCurrentThreadId(),
											hMutex,
											LockData::eLockAction,
											dwStackTrace,
											1,
											dwCallerAddr);
		
		PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_LOCK, (WPARAM)pLockData, (LPARAM)NULL);
	}

	return hMutex;
}

BOOL WINAPI MyReleaseMutex(IN HANDLE hMutex)
{
	DWORD dwStackTrace[10] = { 0 };
	int   nStackDepth = 0;
	DWORD dwCallerAddr = 0;

	g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
	GET_CALLER_ADDR(dwCallerAddr);

	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										hMutex,
										LockData::eUnlockAction,
										dwStackTrace,
										nStackDepth,
										dwCallerAddr);

	//cout << "calling MyReleaseMutex" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_UNLOCK, (WPARAM)pLockData, (LPARAM)NULL);

	return g_pfnOrigReleaseMutex(hMutex);
}

VOID WINAPI MyInitializeCriticalSection(OUT LPCRITICAL_SECTION lpCriticalSection)
{
	//cout << "calling MyInitializeCriticalSection" << endl;
	g_pfnOrigInitializeCriticalSection(lpCriticalSection);
}

VOID WINAPI MyEnterCriticalSection(IN OUT LPCRITICAL_SECTION lpCriticalSection)
{
	DWORD dwStackTrace[10] = { 0 };
	int   nStackDepth = 0;
	DWORD dwCallerAddr = 0;

	g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
	GET_CALLER_ADDR(dwCallerAddr);
	
	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										lpCriticalSection,
										LockData::eLockAction,
										dwStackTrace,
										nStackDepth,
										dwCallerAddr);

	//cout << "calling MyEnterCriticalSection" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_LOCK, (WPARAM)pLockData, (LPARAM)NULL);
	
	g_pfnOrigEnterCriticalSection(lpCriticalSection);
}

VOID WINAPI MyLeaveCriticalSection(IN OUT LPCRITICAL_SECTION lpCriticalSection)
{
	DWORD dwStackTrace[10] = { 0 };
	int   nStackDepth = 0;
	DWORD dwCallerAddr = 0;

	g_pSymServer->GetStack(dwStackTrace, sizeof(dwStackTrace)/sizeof(dwStackTrace[0]), nStackDepth);
	GET_CALLER_ADDR(dwCallerAddr);

	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										lpCriticalSection,
										LockData::eUnlockAction,
										dwStackTrace,
										nStackDepth,
										dwCallerAddr);

	//cout << "calling MyLeaveCriticalSection" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_UNLOCK, (WPARAM)pLockData, (LPARAM)NULL);
	
	g_pfnOrigLeaveCriticalSection(lpCriticalSection);
}

HANDLE WINAPI MyCreateEvent(IN LPSECURITY_ATTRIBUTES lpEventAttributes, IN BOOL bManualReset, IN BOOL bInitialState, IN LPCSTR lpName)
{
	HANDLE hEvent = g_pfnOrigCreateEvent(lpEventAttributes, bManualReset, bInitialState, lpName);

	DWORD dwStackTrace[10] = { 0 };
	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										hEvent,
										LockData::eCreateAction,
										dwStackTrace,
										0,
										0);

	//cout << "calling MyCreateEvent" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_IGNORE, (WPARAM)pLockData, (LPARAM)NULL);
	
	return hEvent;
}

BOOL WINAPI MySetEvent(IN HANDLE hEvent)
{
	DWORD dwStackTrace[10] = { 0 };
	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										hEvent,
										LockData::eSetEventAction,
										dwStackTrace,
										0,
										0);

	//cout << "calling MySetEvent" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_IGNORE, (WPARAM)pLockData, (LPARAM)NULL);

	return g_pfnOrigSetEvent(hEvent);
}

BOOL WINAPI MyResetEvent(IN HANDLE hEvent)
{
	DWORD dwStackTrace[10] = { 0 };
	LockData*  pLockData = new LockData(GetCurrentThreadId(),
										hEvent,
										LockData::eResetEventAction,
										dwStackTrace,
										0,
										0);

	//cout << "calling MyResetEvent" << endl;
	PostThreadMessage(LocksLoggerThread::getInstance()->getThreadID(), WM_LM_IGNORE, (WPARAM)pLockData, (LPARAM)NULL);

	return g_pfnOrigResetEvent(hEvent);
}

BOOL hook()
{
	// hooked functions array
	HOOKFUNCDESCA hookedFuncDescriptor[sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0])];
	// original functions array
	PROC originFuncArray[sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0])];

	memset(hookedFuncDescriptor, 0, sizeof(hookedFuncDescriptor));
	memset(originFuncArray, 0, sizeof(originFuncArray));

	for (int i = 0; i < sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0]); i++)
	{
		hookedFuncDescriptor[i].szFunc = hookedFuncArray[i].m_lpszFuncName;
		hookedFuncDescriptor[i].pProc = hookedFuncArray[i].m_lpszNewFuncName;
	}

	DWORD dwNumHooked = 0;

    BOOL bRet = HookImportedFunctionsByName(GetModuleHandle(NULL) ,
											"Kernel32.DLL",             
											sizeof(hookedFuncDescriptor)/sizeof(hookedFuncDescriptor[0]),
											hookedFuncDescriptor,
											originFuncArray,
											&dwNumHooked);

	for (i = 0; i < sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0]); i++)
	{
		*(hookedFuncArray[i].m_pfnOrigin) = originFuncArray[i];
	}

    if (FALSE == bRet)
    {
        cout << "We couldn't hook it" << endl;
    }

	return bRet;
}

BOOL unhook()
{
	// hooked functions array
	HOOKFUNCDESCA hookedFuncDescriptor[sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0])];
	// original functions array
	PROC originFuncArray[sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0])];

	memset(hookedFuncDescriptor, 0, sizeof(hookedFuncDescriptor));
	memset(originFuncArray, 0, sizeof(originFuncArray));

	for (int i = 0; i < sizeof(hookedFuncArray)/sizeof(hookedFuncArray[0]); i++)
	{
		hookedFuncDescriptor[i].szFunc = hookedFuncArray[i].m_lpszFuncName;
		hookedFuncDescriptor[i].pProc = *(hookedFuncArray[i].m_pfnOrigin);
	}

	DWORD dwNumHooked = 0;

    BOOL bRet = HookImportedFunctionsByName(GetModuleHandle(NULL) ,
											"Kernel32.DLL",             
											sizeof(hookedFuncDescriptor)/sizeof(hookedFuncDescriptor[0]),
											hookedFuncDescriptor,
											originFuncArray,
											&dwNumHooked);

    if (FALSE == bRet)
    {
        cout << "We couldn't unhook it" << endl;
    }

	g_pfnOrigWaitForSingleObject = NULL;
	g_pfnOrigWaitForMultipleObjects = NULL;
	g_pfnOrigCreateMutex = NULL;
	g_pfnOrigReleaseMutex = NULL;
	g_pfnOrigInitializeCriticalSection = NULL;
	g_pfnOrigEnterCriticalSection = NULL;
	g_pfnOrigLeaveCriticalSection = NULL;
	g_pfnOrigCreateEvent = NULL;
	g_pfnOrigSetEvent = NULL;
	g_pfnOrigResetEvent = NULL;

	return bRet;
}
