/////////////////////////////////////////////////////////////////////////////
// SimpleBrowserDemo.cpp: Demo application for SimpleBrowser
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "SimpleBrowser.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define Unused(parameter) parameter					// avoid compile warnings
													// about unused parameters

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Application declaration
/////////////////////////////////////////////////////////////////////////////

class SimpleBrowser_Application : public CWinApp

{

public:

	SimpleBrowser_Application();

	//{{AFX_VIRTUAL(SimpleBrowser_Application)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(SimpleBrowser_Application)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Example declaration
/////////////////////////////////////////////////////////////////////////////

class SimpleBrowser_Dialog;

class SimpleBrowser_Example : public SimpleBrowser {

public:

	virtual bool OnBeforeNavigate2(CString URL,
	                               CString frame,
								   void    *post_data,int post_data_size,
								   CString headers);
    virtual void OnDocumentComplete(CString URL);
    virtual void OnDownloadBegin();
    virtual void OnProgressChange(int progress,int progress_max);
    virtual void OnDownloadComplete();
    virtual void OnNavigateComplete2(CString URL);
    virtual void OnStatusTextChange(CString text);
    virtual void OnTitleChange(CString text);

	SimpleBrowser_Dialog		*Container;

};

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Dialog declaration
/////////////////////////////////////////////////////////////////////////////

class SimpleBrowser_Dialog : public CDialog
{

public:

	SimpleBrowser_Dialog(CWnd* pParent = NULL);

	void Event(CString string);

	void OnOK();

	//{{AFX_DATA(SimpleBrowser_Dialog)
	enum { IDD = IDD_DIALOG };
	CString	m_String;
	CString	m_Events;
	CString m_Notifications;
	CString	m_PrintHeader;
	CString	m_PrintFooter;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(SimpleBrowser_Dialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(SimpleBrowser_Dialog)
	virtual BOOL OnInitDialog();
	afx_msg void OnURL_Navigate();
	afx_msg void OnWrite();
	afx_msg void OnClear();
	afx_msg void OnResourceANSI_Navigate();
	afx_msg void OnResourceUNICODE_Navigate();
	afx_msg void OnPrint();
	afx_msg void OnClearEventsNotifications();

	//}}AFX_MSG

    afx_msg void OnBeforeNavigate2(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnDocumentComplete(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnDownloadBegin(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnProgressChange(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnDownloadComplete(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnNavigateComplete2(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnStatusTextChange(NMHDR *pNMHDR,LRESULT *pResult);
    afx_msg void OnTitleChange(NMHDR *pNMHDR,LRESULT *pResult);

	DECLARE_MESSAGE_MAP()

private:

	SimpleBrowser_Example			_SimpleBrowser_Example;

};

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Application implementation
/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(SimpleBrowser_Application, CWinApp)
	//{{AFX_MSG_MAP(SimpleBrowser_Application)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

SimpleBrowser_Application _SimpleBrowser_Application;

SimpleBrowser_Application::SimpleBrowser_Application()
{
}

BOOL SimpleBrowser_Application::InitInstance()
{
	AfxEnableControlContainer();

	SimpleBrowser_Dialog dlg;
	m_pMainWnd = &dlg;
	dlg.DoModal();

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Dialog implementation
/////////////////////////////////////////////////////////////////////////////

SimpleBrowser_Dialog::SimpleBrowser_Dialog(CWnd* pParent /*=NULL*/)
	: CDialog(SimpleBrowser_Dialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(SimpleBrowser_Dialog)
	m_String        = _T("<html>\r\n")
	                  _T("<body background=\"res://SimpleBrowserDemo.exe/#2/#300\">\r\n")
					  _T("This is an example of using the <code><b><font color=\"#FFFFFF\" size=3>SimpleBrowser</font></b></code>\r\n")
					  _T("class. The background uses the <i>res:</i> protocol to reference a bitmap\r\n")
					  _T("in the program\'s resources.\r\n")
					  _T("</body>\r\n")
					  _T("</html>");
	m_Events        = _T("");
	m_Notifications = _T("");
	m_PrintHeader   = _T("&w&b&b&p");
	m_PrintFooter   = _T("&d &t");
	//}}AFX_DATA_INIT

	_SimpleBrowser_Example.Container = this;
}

void SimpleBrowser_Dialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SimpleBrowser_Dialog)
	DDX_Text(pDX, IDC_STRING, m_String);
	DDX_Text(pDX, IDC_EVENTS, m_Events);
	DDX_Text(pDX, IDC_NOTIFICATIONS, m_Notifications);
	DDX_Text(pDX, IDC_PRINT_HEADER, m_PrintHeader);
	DDX_Text(pDX, IDC_PRINT_FOOTER, m_PrintFooter);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(SimpleBrowser_Dialog, CDialog)
	//{{AFX_MSG_MAP(SimpleBrowser_Dialog)
	ON_BN_CLICKED(IDC_URL_NAVIGATE, OnURL_Navigate)
	ON_BN_CLICKED(IDC_WRITE, OnWrite)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_ANSI_RESOURCE_NAVIGATE, OnResourceANSI_Navigate)
	ON_BN_CLICKED(IDC_UNICODE_RESOURCE_NAVIGATE, OnResourceUNICODE_Navigate)
	ON_BN_CLICKED(IDC_PRINT, OnPrint)
	ON_BN_CLICKED(IDC_CLEAR_EVENTS_NOTIFICATIONS, OnClearEventsNotifications)
	//}}AFX_MSG_MAP
	ON_NOTIFY(SimpleBrowser::BeforeNavigate2,IDC_BROWSER,OnBeforeNavigate2)
	ON_NOTIFY(SimpleBrowser::DocumentComplete,IDC_BROWSER,OnDocumentComplete)
	ON_NOTIFY(SimpleBrowser::DownloadBegin,IDC_BROWSER,OnDownloadBegin)
	ON_NOTIFY(SimpleBrowser::ProgressChange,IDC_BROWSER,OnProgressChange)
	ON_NOTIFY(SimpleBrowser::DownloadComplete,IDC_BROWSER,OnDownloadComplete)
	ON_NOTIFY(SimpleBrowser::NavigateComplete2,IDC_BROWSER,OnNavigateComplete2)
	ON_NOTIFY(SimpleBrowser::StatusTextChange,IDC_BROWSER,OnStatusTextChange)
	ON_NOTIFY(SimpleBrowser::TitleChange,IDC_BROWSER,OnTitleChange)
END_MESSAGE_MAP()

// Message and control handlers

BOOL SimpleBrowser_Dialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	HICON icon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	SetIcon(icon, TRUE);
	SetIcon(icon, FALSE);
	
	_SimpleBrowser_Example.CreateFromControl(this,IDC_BROWSER);

	return TRUE;
}

void SimpleBrowser_Dialog::OnOK()
{
}

void SimpleBrowser_Dialog::OnURL_Navigate() 
{
	if (UpdateData(TRUE)) {
		_SimpleBrowser_Example.Navigate(m_String);
	}
}

void SimpleBrowser_Dialog::OnWrite() 
{
	if (UpdateData(TRUE)) {
		_SimpleBrowser_Example.Write(m_String);
	}
}

void SimpleBrowser_Dialog::OnClear() 
{
	_SimpleBrowser_Example.Clear();
}

void SimpleBrowser_Dialog::OnResourceANSI_Navigate() 
{
	_SimpleBrowser_Example.NavigateResource(IDR_HTML_ANSI);
}

void SimpleBrowser_Dialog::OnResourceUNICODE_Navigate() 
{
	_SimpleBrowser_Example.NavigateResource(IDR_HTML_UNICODE);
}

void SimpleBrowser_Dialog::OnPrint() 
{
	if (UpdateData(TRUE)) {
		_SimpleBrowser_Example.Print(m_PrintHeader,m_PrintFooter);
	}
}

// Event handler

void SimpleBrowser_Dialog::Event(CString string)
{
	m_Events += string;
	m_Events += _T("\r\n");
	UpdateData(FALSE);

	GetDlgItem(IDC_EVENTS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_EVENTS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);
}

// Notification handlers

void SimpleBrowser_Dialog::OnBeforeNavigate2(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
	CString string;

	string.Format(_T("OnBeforeNavigate2: \"%s\", \"%s\", [0x%08X,%d bytes], \"%s\"\r\n"),
	              notification->URL,
				  notification->frame,
				  notification->post_data,notification->post_data_size,
				  notification->headers);

    m_Notifications += string;
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnDocumentComplete(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
    m_Notifications += _T("OnDocumentComplete: \"") + 
	                   notification->URL + _T("\"\r\n");
	UpdateData(FALSE);
	
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnDownloadBegin(NMHDR *pNMHDR,LRESULT *pResult)
{
	Unused(pNMHDR);
	
    m_Notifications += _T("OnDownloadBegin\r\n");
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnProgressChange(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
    CString string;
    string.Format(_T("OnProgressChange: %d,%d\r\n"),
	              notification->progress,
				  notification->progress_max);
    m_Notifications += string;
    UpdateData(FALSE);

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnDownloadComplete(NMHDR *pNMHDR,LRESULT *pResult)
{
	Unused(pNMHDR);
	
    m_Notifications += _T("OnDownloadComplete\r\n");
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnNavigateComplete2(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
    m_Notifications += _T("OnNavigateComplete2: \"") + 
	                   notification->URL + _T("\"\r\n");
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnStatusTextChange(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
    m_Notifications += _T("OnStatusTextChange: \"") + 
	                   notification->text + _T("\"\r\n");
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnTitleChange(NMHDR *pNMHDR,LRESULT *pResult)
{
	SimpleBrowser::Notification	
		*notification = (SimpleBrowser::Notification *)pNMHDR;
		
    m_Notifications += _T("OnTitleChange: \"") + 
	                   notification->text + _T("\"\r\n");
    UpdateData(FALSE);    

	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SETSEL,(WPARAM)0,(LPARAM)-1);
	GetDlgItem(IDC_NOTIFICATIONS)->PostMessage(EM_SCROLLCARET,(WPARAM)0,(LPARAM)0);

	*pResult = 0;
}

void SimpleBrowser_Dialog::OnClearEventsNotifications() 
{
	m_Events        = _T("");
	m_Notifications = _T("");
	UpdateData(FALSE);	
}

/////////////////////////////////////////////////////////////////////////////
// SimpleBrowser_Example implementation
/////////////////////////////////////////////////////////////////////////////

bool SimpleBrowser_Example::OnBeforeNavigate2(CString URL,
                                              CString frame,
								              void    *post_data,int post_data_size,
								              CString headers)
{
	SimpleBrowser::OnBeforeNavigate2(URL,frame,post_data,post_data_size,headers);

	CString event;
	event.Format(_T("OnBeforeNavigation: URL=\"%s\", frame=\"%s\", post_data=[0x%08X,%d bytes], headers=\"%s\""),
	             URL,frame,post_data,post_data_size,headers);
	Container->Event(event);
	return false;
}

void SimpleBrowser_Example::OnDocumentComplete(CString URL)
{
	SimpleBrowser::OnDocumentComplete(URL);

	CString event;
	event.Format(_T("OnDocumentComplete: URL=\"%s\""),
	             URL);
	Container->Event(event);
}

void SimpleBrowser_Example::OnDownloadBegin()
{
	SimpleBrowser::OnDownloadBegin();
	
	Container->Event(_T("OnDownloadBegin"));
}

void SimpleBrowser_Example::OnProgressChange(int progress,int progress_max)
{
	SimpleBrowser::OnProgressChange(progress,progress_max);
	
	CString event;
	event.Format(_T("OnProgressChange: progress=%d, progress_max=%d"),
	             progress,progress_max);
	Container->Event(event);
}

void SimpleBrowser_Example::OnDownloadComplete()
{
	SimpleBrowser::OnDownloadComplete();
	
	Container->Event(_T("OnDownloadComplete"));
}

void SimpleBrowser_Example::OnNavigateComplete2(CString URL)
{
	SimpleBrowser::OnNavigateComplete2(URL);
	
	CString event;
	event.Format(_T("OnNavigationComplete2: URL=\"%s\""),URL);
	Container->Event(event);
}

void SimpleBrowser_Example::OnStatusTextChange(CString text)
{
	SimpleBrowser::OnStatusTextChange(text);
	
	CString event;
	event.Format(_T("OnStatusTextChange: text=\"%s\""),text);
	Container->Event(event);
}

void SimpleBrowser_Example::OnTitleChange(CString text)
{
	SimpleBrowser::OnTitleChange(text);
	
	CString event;
	event.Format(_T("OnTitleChange: text=\"%s\""),text);
	Container->Event(event);

	Container->GetDlgItem(IDC_BROWSER_TITLE)->SetWindowText(text);
}

