-----------------------------------------------------------------------------------------------------------------
-- garbagecalendar module script: m_opzet_api.lua
----------------------------------------------------------------------------------------------------------------
ver = '20210421-2000'
websitemodule = 'm_opzet_api'
-- Link to WebSite:  variable, needs to be defined in the garbagecalendarconfig.lua in field Hostname.
--
-------------------------------------------------------
-- get script directory
function script_path()
   return arg[0]:match('.*[/\\]') or './'
end
-- only include when run in separate process
if scriptpath == nil then
   dofile(script_path() .. 'generalfuncs.lua') --
end
-------------------------------------------------------
-- Do the actual update retrieving data from the website and processing it
function Perform_Update()
   function processdata(ophaaldata)
      --for i = 1, #ophaaldata do
      for record, data in pairs(ophaaldata) do
         if type(data) == 'table' then
            web_garbageid = data.afvalstroom_id
            web_garbagetype = ''
            web_garbagedate = data.ophaaldatum
            wnameType = ''
            for i = 1, #garbagedata do
               record = garbagedata[i]
               if type(record) == 'table' then
                  if web_garbageid == record['id'] then
                     web_garbagetype = record['title']
                     break
                  end
               end
            end
            dprint('  web_garbageid:' .. web_garbageid .. ' Afvalsoort : ' .. web_garbagetype .. '   web_garbagedate:' .. web_garbagedate)
            local dateformat = '????????'
            -- Get days diff
            dateformat, daysdiffdev = GetDateFromInput(web_garbagedate, '(%d+)[-%s]+(%d+)[-%s]+(%d+)', {'yyyy', 'mm', 'dd'})
            if daysdiffdev == nil then
               dprint('Invalid date from web for : ' .. web_garbagetype .. '   date:' .. web_garbagedate)
               return
            end
            if (daysdiffdev >= 0) then
               garbagedata[#garbagedata + 1] = {}
               garbagedata[#garbagedata].garbagetype = web_garbagetype
               garbagedata[#garbagedata].garbagedate = dateformat
            -- field to be used when WebData contains a description
            -- garbagedata[#garbagedata].wdesc = ....
            end
         end
      end
   end
   dprint('---- web update ----------------------------------------------------------------------------')
   local Web_Data
   -- Get the information for the specified address specifically the bagId for the subsequent calls
   Web_Data = perform_webquery('"https://' .. Hostname .. '/rest/adressen/' .. Zipcode .. '-' .. Housenr .. '"')
   if Web_Data == '' then
      return
   end
   if (Web_Data:sub(1, 2) == '[]') then
      dprint('### Error: Check your Zipcode and Housenr as we get an [] response.')
      return
   end
   adressdata = JSON:decode(Web_Data)
   -- Decode JSON table and find the appropriate address when there are multiple options when toevoeging is used like 10a
   for i = 1, #adressdata do
      record = adressdata[i]
      dprint('Address options: ' .. record['huisletter'] .. '=' .. Housenrsuf .. '->' .. record['bagId'])
      if type(record) == 'table' then
         if Housenrsuf == record['huisletter'] then
            bagId = record['bagId']
            break
         end
      end
   end
   if bagId == nil or bagId == '' then
      dprint('### Error: No bagId retrieved...  stopping execution.')
      return
   end
   dprint('bagId:' .. bagId)
   -- get the Afvalstromen information for all possible garbagetypeid's for this address(bagId)
   Web_Data = perform_webquery('"https://' .. Hostname .. '/rest/adressen/' .. bagId .. '/afvalstromen"')
   if (Web_Data:sub(1, 2) == '[]') then
      dprint('### Error: Unable to retrieve Afvalstromen information...  stopping execution.')
      return
   end
    -- remove Icon data as that messes things up
   --
   -- Strip Icon info as that contains much data which is giving JSON lexing problems.
   Web_Data = Web_Data:gsub('(,"icon_data":".-",)', ',')
   dprint("==== Stripped 1 ========================================================")
   dprint(Web_Data)
   --
   -- Strip \ infront of "" to ensuree the next stripping will work
   Web_Data = Web_Data:gsub('(\\")', '"')
   dprint("==== Stripped 2 ========================================================")
   dprint(Web_Data)
   --
   -- Strip content info as that contains much data which is giving JSON lexing problems.
   Web_Data = Web_Data:gsub('(,"content":".-",)', ',')
   dprint("==== Stripped 2 ========================================================")
   dprint(Web_Data)
   dprint("============================================================")
   garbagedata = JSON:decode(Web_Data)
   -- get the Kalender information for this address(bagId) for the current year
   local Web_Data = perform_webquery('"https://' .. Hostname .. '/rest/adressen/' .. bagId .. '/ophaaldata"')
   if (Web_Data:sub(1, 2) == '[]') then
      dprint('### Error: Unable to retrieve the Kalender information for this address...  stopping execution.')
      return
   end
   jdata = JSON:decode(Web_Data)
   -- get the ophaaldagen tabel for the coming scheduled pickups
   if type(jdata) ~= 'table' then
      dprint('### Error: Empty Kalender found stopping execution.')
      return
   end
   -- process the data
   dprint('- start looping through received data -----------------------------------------------------------')
   processdata(jdata)
end
-- End Functions =========================================================================

-- Start of logic ========================================================================
timenow = os.date('*t')
-- get paramters from the commandline
domoticzjsonpath = domoticzjsonpath or arg[1]
Zipcode = Zipcode or arg[2]
Housenr = Housenr or arg[3] or ''
Housenrsuf = Housenrsuf or arg[4]
afwdatafile = datafile or arg[5]
afwlogfile = weblogfile or arg[6]
Hostname = (Hostname or arg[7]) or '' -- Not needed
Street = (Street or arg[8]) or '' -- Not needed
-- other variables
garbagedata = {} -- array to save information to which will be written to the data file

dprint('#### ' .. os.date('%c') .. ' ### Start garbagecalendar module ' .. websitemodule .. ' (v' .. ver .. ')')
if domoticzjsonpath == nil then
   dprint('!!! domoticzjsonpath not specified!')
elseif Zipcode == nil then
   dprint('!!! Zipcode not specified!')
elseif Housenr == nil then
   dprint('!!! Housenr not specified!')
elseif Housenrsuf == nil then
   dprint('!!! Housenrsuf not specified!')
elseif Hostname == '' then
   dprint('!!! Hostname not specified!')
elseif afwdatafile == nil then
   dprint('!!! afwdatafile not specified!')
elseif afwlogfile == nil then
   dprint('!!! afwlogfile not specified!')
else
   -- Load JSON.lua
   if pcall(loaddefaultjson) then
      dprint('Loaded JSON.lua.')
   else
      dprint('### Error: failed loading default JSON.lua and Domoticz JSON.lua: ' .. domoticzjsonpath .. '.')
      dprint('### Error: Please check your setup and try again.')
      os.exit() -- stop execution
   end
   dprint('!!! perform background update to ' .. afwdatafile .. ' for Zipcode ' .. Zipcode .. ' - ' .. Housenr .. Housenrsuf .. '  (optional) Hostname:' .. Hostname)
   Perform_Update()
   dprint('=> Write data to ' .. afwdatafile)
   table.save(garbagedata, afwdatafile)
end
