// Make cross platform
import AsyncStorage from '@react-native-community/async-storage';

export default {
  get: async (key) => {
    const obj = await AsyncStorage.getItem(key);
    return obj ? JSON.parse(obj) : null;
  },
  set: (key, value) => {
    AsyncStorage.setItem(key, JSON.stringify(value));
  },
  remove: (key) => {
    AsyncStorage.removeItem(key);
  },
};
