import axios from 'axios';
import store from './store';
// import { API_URL } from 'react-native-dotenv';
export const API_URL = 'https://api.jongerenbedrijvendag.nl';

const client = axios.create({
  baseURL: API_URL,
});

client.interceptors.request.use(function (req) {
  const state = store.getState().auth;

  if (state.authToken) {
    req.headers.Authorization = `Bearer ${state.authToken.token}`;
  }

  return req;
});

client.interceptors.response.use(
  function (res) {
    return res;
  },
  function (err) {
    return err.response;
  }
);

export default client;
