import { Component } from 'react';
import {BackHandler} from "react-native";
import {NavigationActions} from "react-navigation";
import PropTypes from 'prop-types';
import NavigationService from "../shared/services/NavigationService";

export default class BackButtonComponent extends Component {
    componentDidMount() {
        BackHandler.addEventListener("hardwareBackPress", this.onBackPress);
    }

    componentWillUnmount() {
        BackHandler.removeEventListener("hardwareBackPress", this.onBackPress);
    }

    /*
    / Catch hardware back button (Android) and hook it to the navigation
    / This is needed as we use Redux within the application, so react-navigation
    / doesn't handle it automatically.
     */
    onBackPress = () => {
        NavigationService.goBack();

        // We do not want default behaviour of the back button, which would
        // close the app, in this case. So we return true.

        return true;
    };
}

BackButtonComponent.propTypes = {
    navigation: PropTypes.object,
    auth: PropTypes.object
};
