import React, {Component} from 'react';
import {TouchableOpacity} from 'react-native';
import PropTypes from 'prop-types';
import Icon from 'react-native-vector-icons/FontAwesome';
import NavigationService from '../shared/services/NavigationService';

class MenuButton extends Component {
  menuButtonPress() {
    const {state, toggleDrawer} = this.props.navigation;
    if (state.params && state.params.isDetail) {
      NavigationService.goBack();
    } else {
      toggleDrawer();
    }
  }

  render() {
    const {state} = this.props.navigation;

    let isDetail = state.params && state.params.isDetail;

    return (
      <TouchableOpacity
        onPress={() => this.menuButtonPress()}
        style={styles.touchableStyle}>
        {isDetail ? (
          <Icon name={'chevron-left'} color={'white'} size={22} />
        ) : (
          <Icon name={'bars'} color={'white'} size={22} />
        )}
      </TouchableOpacity>
    );
  }
}
const styles = {
  iconStyle: {
    marginTop: 2,
    width: 24,
    height: 24,
  },
  touchableStyle: {
    padding: 10,
    marginLeft: 10,
  },
};

MenuButton.propTypes = {
  navigation: PropTypes.object,
};

export default MenuButton;
