import PropTypes from 'prop-types';
import { Button } from 'react-native-elements';

import React, { Component } from 'react';
import Color from 'color';

const buttonStyle = {
    paddingHorizontal: 30,
    minWidth: 150,
    paddingVertical: 10,
    borderRadius: 5
};

const buttonStyleDown = {
    backgroundColor: "#007cbe"
};

export default class RaisedButton extends Component {
    state = { down: false };

    setButtonDownState(state) {
        this.setState({down: state});
    }

    getBorderColor() {
        if(this.props.disabled) {
            return Color(this.props.color).grayscale().lighten(0.15).string()
        }
        return Color(this.props.color).lighten(0.15).string();
    }

    getDownColor() {
        if(this.props.disabled) {
            return Color(this.props.color).grayscale().darken(0.15).string()
        }
        return Color(this.props.color).darken(0.15).string();
    }

    render() {
        const { style, disabled, color } = this.props;

        return (
            <Button
                onPressIn={() => this.setButtonDownState(true)}
                onPressOut={() => this.setButtonDownState(false)}
                delayPressIn={0}
                delayPressOut={0}
                {...this.props}
                buttonStyle={[
                    buttonStyle,
                    {
                        backgroundColor: this.props.color,
                        borderColor: this.getBorderColor()
                    },
                    this.state.down ? {...buttonStyleDown, backgroundColor: this.getDownColor()} : null,
                    style
                ]}
                disabledStyle={ {
                    backgroundColor: Color(color).desaturate(1).alpha(0.25).string(),
                    borderColor: Color(color).darken(0.25).desaturate(1).alpha(0.25).string()
                } }
                color={ disabled ? "#a1a1a1" : "white" }
                textStyle={{ textAlign: 'center', color: disabled ? "#a1a1a1" : "white" }} >
                {this.props.children}
            </Button>
        );
    }
}

RaisedButton.propTypes = {
    style: PropTypes.object,
    onPress: PropTypes.func,
    color: PropTypes.string,
    disabled: PropTypes.bool,
    children: PropTypes.node
};

RaisedButton.defaultProps = {
  color: "#008cd6"
};