import React from 'react';
import PropTypes from 'prop-types';
import {View, Text, Image, TouchableWithoutFeedback, Platform} from 'react-native';
import WebView from 'react-native-webview';
import Moment from "moment/min/moment-with-locales";


class RouteMapSlotCard extends React.Component {
    onSelect() {
        if (this.props.isCompany) {
            // this.props.onSelectCompany(this.props.destination.id);
        }
    }

    render() {
        const {company} = this.props;
        return (
            <TouchableWithoutFeedback onPress={() => this.onSelect()} style={{flex: 1}}>
                <View style={{backgroundColor: "white", padding: 15}}>
                    {(company.logo) ? Platform.select({
                        android: <WebView source={{
                            html: `<html><body style="padding: 0; margin: 0;">
                                    <img style="width: 100%; object-fit: contain; height: 30px;" src="${company.logo}" />
                                   </body></html>` }}
                                          style={{width: 100, height: 30}}/>,
                        ios: <Image style={{width: 100, height: 30}} resizeMode={"contain"}
                                    source={{uri: company.logo}}/>
                    }) : null}
                    <Text style={{fontWeight: "bold"}}>{company.name}</Text>
                    {company.address && <Text style={{
                        color: "#ccc",
                        fontSize: 12
                    }}>{`${company.address.street || ""} ${company.address.number || ""}${company.address.numberAddition || ""}, ${company.address.city || ""}`}</Text>}
                </View>
            </TouchableWithoutFeedback>
        );
    }
}

RouteMapSlotCard.propTypes = {
    company: PropTypes.object,
    onSelectCompany: PropTypes.func,
};

export default RouteMapSlotCard;
