import React from 'react';
import PropTypes from 'prop-types';
import {View, Text, Image, TouchableWithoutFeedback, Platform} from 'react-native';
import WebView from 'react-native-webview';
import Moment from "moment/min/moment-with-locales";


class RouteMapSlotCard extends React.Component {
    onSelect() {
        if (this.props.isCompany) {
            // this.props.onSelectCompany(this.props.destination.id);
        }
    }

    render() {
        const {destination, slot, isCompany} = this.props;
        return (
            <TouchableWithoutFeedback onPress={() => this.onSelect()} style={{flex: 1}}>
                <View style={{backgroundColor: "white", padding: 15}}>
                    {(isCompany && destination.logo) ? Platform.select({
                        android: <WebView source={{
                            html: `<html><body style="padding: 0; margin: 0;">
                                    <img style="width: 100%; object-fit: contain; height: 30px;" src="${destination.logo}" />
                                   </body></html>` }}
                                          style={{width: 100, height: 30}}/>,
                        ios: <Image style={{width: 100, height: 30}} resizeMode={"contain"}
                                    source={{uri: destination.logo}}/>
                    }) : null}
                    <Text style={{fontWeight: "bold"}}>{destination.name}</Text>
                    <Text style={{color: "#ccc", fontSize: 12}}>{slot.name} ({Moment(slot.start).format("HH:mm")} - {Moment(slot.end).format("HH:mm")})</Text>
                    <Text style={{
                        color: "#ccc",
                        fontSize: 12
                    }}>{`${destination.address.street || ""} ${destination.address.number || ""}${destination.address.numberAddition || ""}, ${destination.address.city || ""}`}</Text>
                </View>
            </TouchableWithoutFeedback>
        );
    }
}

RouteMapSlotCard.propTypes = {
    slot: PropTypes.object,
    destination: PropTypes.object,
    isCompany: PropTypes.bool,
    onSelectCompany: PropTypes.func,
};

export default RouteMapSlotCard;
