import React from 'react';
import PropTypes from 'prop-types';

import MenuButton from 'app/components/MenuButton';
import BackButtonComponent from 'app/components/BackButtonComponent';

import {TouchableOpacity} from 'react-native';
import Icon from 'react-native-vector-icons/FontAwesome';
import NavigationService from '../shared/services/NavigationService';
import store from '../store';

export default class Screen extends BackButtonComponent {
  static renderNewMessageButton() {
    return (
      <TouchableOpacity
        onPress={() =>
          NavigationService.navigate('messagesCompose', {isDetail: true})
        }
        style={styles.touchableStyle}>
        <Icon name={'plus'} color={'white'} size={22} />
      </TouchableOpacity>
    );
  }

  static navigationOptions = ({navigation}) => {
    return {
      headerStyle: {
        backgroundColor: '#008cd6',
        textColor: 'white',
        padding: 0,
        height: 50,
      },
      headerForceInset: {top: 'never', bottom: 'never'},

      headerTintColor: '#fff',
      headerTitleStyle: {
        marginTop: 0,
        fontWeight: 'bold',
        padding: 0,
      },
      title:
        (navigation.state.params ? navigation.state.params.title : null) ||
        'Bedrijven',
      headerLeft: <MenuButton navigation={navigation} />,
      headerRight:
        navigation.state.routeName === 'messages' &&
        store.getState().auth.permissions &&
        store
          .getState()
          .auth.permissions.groups[0].accessLevel.includes('Guide')
          ? Screen.renderNewMessageButton()
          : null,
    };
  };
}

const styles = {
  iconStyle: {
    marginTop: 2,
    width: 24,
    height: 24,
  },
  touchableStyle: {
    padding: 10,
    marginRight: 10,
  },
};

Screen.propTypes = {
  navigation: PropTypes.object,
};
