import React, {Component} from 'react';
import PropTypes from 'prop-types';
import { ScrollView, View, Text, TouchableOpacity } from 'react-native';
import {connect} from "react-redux";
import {DrawerItems} from 'react-navigation-drawer';

class SideMenu extends Component {
    render() {
        return (
            <ScrollView style={{flex:1}}>
                <View style={{flex:1, flexDirection: "row", alignItems: "center", justifyContent: "space-between", height: 80}}>
                    <Text style={{fontSize: 30, fontWeight: "bold", paddingLeft: 30}}>Menu</Text>
                    <TouchableOpacity onPress={() => this.props.navigation.toggleDrawer()}>
                        <Text style={{paddingHorizontal:40, fontSize: 30}} name="x" color={"lightgrey"}>&times;</Text>
                    </TouchableOpacity>
                </View>
                <DrawerItems {...this.props} />
            </ScrollView>);
    }
}

SideMenu.propTypes = {
    navigation: PropTypes.object.isRequired
};

const mapStateToProps = () => {
    return {};
};

const mapDispatchToProps = {};
export default connect(mapStateToProps, mapDispatchToProps)(SideMenu);
