import React from 'react';
import PropTypes from 'prop-types';
import {View, Text, Image, TouchableOpacity} from 'react-native';
import Timeline from 'react-native-timeline-flatlist';
import Icon from 'react-native-vector-icons';
import Moment from 'moment/min/moment-with-locales';
import * as moment from 'moment/min/moment-with-locales.min';
import {FlatList} from 'react-native-gesture-handler';

class TimelineSection extends React.Component {
  componentDidMount() {}

  onCardClick(data) {
    if (data.isCompany) {
      this.props.onSelectCompany(data.id);
    }
  }

  renderDetail(rowData) {
    let title = <Text style={{fontWeight: 'bold'}}>{rowData.title}</Text>;
    return (
      <TouchableOpacity onPress={() => this.onCardClick(rowData)}>
        <View
          style={{
            backgroundColor: 'white',
            borderWidth: 0.5,
            borderColor: '#ddd',
            padding: 15,
          }}>
          {rowData.logo ? (
            <Image
              style={{width: '100%', height: 30}}
              resizeMode={'contain'}
              source={{uri: rowData.logo}}
            />
          ) : null}
          {title}
          <Text style={{color: '#ccc', fontSize: 12}}>{rowData.slotName}</Text>
          <Text style={{color: '#ccc', fontSize: 12}}>
            {rowData.description}
          </Text>
        </View>
      </TouchableOpacity>
    );
  }

  renderTime(rowData) {
    return (
      <View style={{flexDirection: 'column', alignItems: 'flex-end'}}>
        <Text style={{}}>{rowData.start}</Text>
        <Text style={{fontSize: 12, color: '#aaa'}}>{rowData.end}</Text>
      </View>
    );
  }

  slotToTimelineItem(slot) {
    let destination = slot.company;
    let isCompany = true;
    if (!destination) {
      isCompany = false;
      destination = slot.school;
      if (!destination) {
        destination = slot.location;
      }
    }

    if (!destination || destination.hidden) {
      return {
        start: Moment(slot.start).format('HH:mm'),
        end: Moment(slot.end).format('HH:mm'),
        id: 'hidden',
        isCompany: false,
        icon: () => <Icon name={'marker'} />,
        title: '',
        slotName: `${slot.name}  (${Moment(slot.start).format(
          'HH:mm',
        )} - ${Moment(slot.end).format('HH:mm')})`,
        description: `Wordt bekend gemaakt op ${Moment(
          this.props.event.revealAt,
        ).format('LL')} om ${Moment(this.props.event.revealAt).format(
          'HH:mm ',
        )}`,
        lineColor: this.props.iconColor,
        logo: isCompany ? slot.company.logo : undefined,
      };
    }

    return {
      start: Moment(slot.start).format('HH:mm'),
      end: Moment(slot.end).format('HH:mm'),
      id: destination.id,
      isCompany: isCompany,
      icon: () => <Icon name={'marker'} />,
      title: destination.name,
      slotName: `${slot.name}  (${Moment(slot.start).format(
        'HH:mm',
      )} - ${Moment(slot.end).format('HH:mm')})`,
      description: destination.address
        ? `${destination.address.street || ''} ${
            destination.address.number || ''
          }${destination.address.numberAddition || ''}, ${
            destination.address.city || ''
          }`
        : '',
      lineColor: this.props.iconColor,
      logo: isCompany ? slot.company.logo : undefined,
    };
  }

  render() {
    const {revealed} = this.props;

    return (
      <View style={{flex: 1, padding: 20}}>
        {!revealed ? (
          <Text style={{textAlign: 'center', marginBottom: 20}}>
            Jouw route wordt bekend gemaakt op{' '}
            {Moment(this.props.event.revealAt).format('LL ')}
            om {Moment(this.props.event.revealAt).format('HH:mm')}.
          </Text>
        ) : null}
        <Timeline
          options={{
            scrollEnabled: false,
            disableVirtualization: true,
          }}
          data={this.props.slots.map((s) => this.slotToTimelineItem(s))}
          renderTime={(r) => this.renderTime(r)}
          renderDetail={(r) => this.renderDetail(r)}
        />
      </View>
    );
  }
}

TimelineSection.propTypes = {
  navigation: PropTypes.object,
  event: PropTypes.object,
  revealed: PropTypes.bool,
  slots: PropTypes.array,
  iconColor: PropTypes.string,
  onSelectCompany: PropTypes.func,
};

export default TimelineSection;
