/* eslint-disable react-native/no-inline-styles */
import React, {useEffect, useState} from 'react';
import {
  RefreshControl,
  Text,
  View,
  FlatList,
  TouchableOpacity,
} from 'react-native';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';
import * as moment from 'moment/min/moment-with-locales.min';
import {organisationsSetActiveSlug} from '../../shared/actions/companies';
import axios from '../../axios-config';
import NavigationService from '../../shared/services/NavigationService';
import MenuButton from 'app/components/MenuButton';

function PublicOrganisationsScreen(props) {
  const [organisations, setOrganisations] = useState();

  const onClickOrganisation = (organisation) => {
    props.organisationsSetActiveSlug(organisation.slug);
    NavigationService.navigate('companies', {isDetail: true});
  };

  const getOrganisations = async () => {
    setOrganisations(undefined);
    const organisationsResponse = await axios.get('/public/organisations');
    const orgs = organisationsResponse.data.data;
    setOrganisations(orgs);

    if (orgs.length === 1) {
      onClickOrganisation(orgs[0]);
    }
  };

  useEffect(() => {
    moment.locale('nl');
    getOrganisations();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  const renderOrganisation = (organisation) => {
    return (
      <TouchableOpacity onPress={() => onClickOrganisation(organisation)}>
        <View style={{padding: 15}}>
          <Text style={{textAlign: 'center', fontWeight: 'bold', fontSize: 18}}>
            {organisation.name}
          </Text>
        </View>
      </TouchableOpacity>
    );
  };

  return (
    <FlatList
      style={{flex: 1}}
      refreshControl={
        <RefreshControl
          refreshing={organisations === undefined}
          onRefresh={getOrganisations}
        />
      }
      data={[]}
      renderItem={() => null}
      ListFooterComponent={
        organisations ? (
          <>
            <Text
              style={{
                fontWeight: 'bold',
                padding: 30,
                textAlign: 'center',
                fontSize: 16,
              }}>
              Kies hieronder de gemeente waar je de deelnemende bedrijven van
              wilt zien.
            </Text>
            <FlatList
              data={organisations.map((c) => {
                c.key = c.id;
                return c;
              })}
              renderItem={({item}) => renderOrganisation(item)}
            />
          </>
        ) : null
      }
    />
  );
}

const mapStateToProps = (state) => {
  return {};
};

const mapDispatchToProps = (dispatch) => {
  return bindActionCreators(
    {
      organisationsSetActiveSlug,
    },
    dispatch
  );
};

PublicOrganisationsScreen.navigationOptions = ({navigation}) => {
  return {
    headerStyle: {
      backgroundColor: '#008cd6',
      textColor: 'white',
      padding: 0,
      height: 50,
    },
    headerForceInset: {top: 'never', bottom: 'never'},

    headerTintColor: '#fff',
    headerTitleStyle: {
      marginTop: 0,
      fontWeight: 'bold',
      padding: 0,
    },
    title:
      (navigation.state.params ? navigation.state.params.title : null) ||
      'Gemeentes',

    headerLeft: <MenuButton navigation={navigation} />,
  };
};

export default connect(
  mapStateToProps,
  mapDispatchToProps
)(PublicOrganisationsScreen);
