import React from 'react';
import PropTypes from 'prop-types';
import {ScrollView, Text, View} from 'react-native';
import {Card} from 'react-native-elements';
import {connect} from "react-redux";
import Screen from "../../components/Screen";
import * as moment from "moment/min/moment-with-locales.min";
import TimeAgo from 'javascript-time-ago';
import nl from 'javascript-time-ago/locale/nl';
import Avatar from "../../components/Avatar";

class MessageDetailScreen extends Screen {

    componentDidMount() {
        TimeAgo.addLocale(nl);
        moment.locale("nl");
    }

    componentDidUpdate() {
    }


    render() {
        const {message} = this.props;
        if (!message) {
            return <View/>;
        }

        return (
            <ScrollView style={{flex: 1, paddingBottom: 50}}>
                <View style={{marginBottom: 20}}>
                    <Card>
                        <View style={{flexDirection: "row", alignItems: "center"}}>
                            <Avatar message={message}/>
                            <View style={{marginLeft: 10}}>
                                <Text style={{fontWeight: "bold"}}>{message.sender.name}</Text>
                                <Text style={{fontSize: 12}}>{new TimeAgo("nl").format(new Date(message.receivedAt))}</Text>
                            </View>
                        </View>
                    </Card>
                    <Card title={message.subject}>
                        <Text>{message.body}</Text>
                    </Card>
                </View>
            </ScrollView>
        );
    }
}

MessageDetailScreen.propTypes = {
    dispatch: PropTypes.func,
    navigation: PropTypes.object,
    auth: PropTypes.object
};

const mapStateToProps = (state) => {
    return {
        message: state.messages.list.find(m => m.id === state.messages.lastLoaded)
    };
};

const mapDispatchToProps = {};

export default connect(mapStateToProps, mapDispatchToProps)(MessageDetailScreen);
