import React from 'react';
import PropTypes from 'prop-types';
import {FlatList, ScrollView, Text, View} from 'react-native';
import {Card} from 'react-native-elements';
import {connect} from 'react-redux';
import RaisedButton from '../../components/RaisedButton';
import Screen from '../../components/Screen';
import {FormInput, FormLabel} from 'react-native-elements';
import {messagesSendMessage, messagesGetAll} from '../../shared/actions';
import {showMessage} from 'react-native-flash-message/src/index';
import NavigationService from '../../shared/services/NavigationService';

class MessagesComposeScreen extends Screen {
  state = {
    subject: '',
    body: '',
  };

  setValue(type, value) {
    this.setState({...this.state, [type]: value});
  }

  sendMessage() {
    this.props.messagesSendMessage(
      this.props.userId,
      this.props.group,
      this.state.subject,
      this.state.body,
    );
  }

  componentDidUpdate(oldState) {
    if (
      this.props.messages.error &&
      this.props.messages.error !== oldState.messages.error
    ) {
      showMessage({
        message: this.props.messages.error,
        type: 'danger',
      });
    }

    if (
      !this.props.messages.loading &&
      oldState.messages.loading &&
      !this.props.messages.error
    ) {
      showMessage({
        message: 'Bericht verzonden!',
        type: 'success',
      });

      this.props.messagesGetAll(this.props.userId);

      NavigationService.navigate('messages');
    }
  }

  render() {
    const components = (
      <>
        <View style={{marginBottom: 20}}>
          <Card>
            <Text style={{fontWeight: 'bold'}}>
              Stuur een bericht naar je groep
            </Text>
            <Text style={{fontSize: 12}}>
              Dit bericht wordt alleen naar leden van groep{' '}
              {this.props.group.name} gestuurd.
            </Text>
          </Card>
          <Card>
            <FormLabel labelStyle={styles.label}>Onderwerp</FormLabel>
            <FormInput
              containerStyle={styles.inputStyle}
              inputStyle={styles.label}
              value={this.state.subject}
              onChangeText={(value) => this.setValue('subject', value)}
              placeholder="Onderwerp"
            />

            <FormLabel labelStyle={styles.label}>Bericht</FormLabel>
            <FormInput
              containerStyle={styles.inputStyle}
              inputStyle={styles.label}
              multiline={true}
              numberOfLines={3}
              value={this.state.body}
              onChangeText={(value) => this.setValue('body', value)}
              placeholder="Bericht"
            />
          </Card>
          <View style={styles.buttonContainer}>
            <RaisedButton
              title={'Versturen'}
              onPress={() => this.sendMessage()}
              loading={this.props.messages.loading}
              disabled={
                this.props.messages.loading ||
                this.state.body === '' ||
                this.state.subject === ''
              }
            />
          </View>
        </View>
      </>
    );

    return (
      <FlatList
        data={[]}
        style={{flex: 1, paddingBottom: 50}}
        renderItem={() => null}
        ListFooterComponent={components}
      />
    );
  }
}

const styles = {
  scrollContainerStyle: {
    flex: 1,
    alignItems: 'stretch',
    justifyContent: 'space-around',
  },
  buttonContainer: {
    marginTop: 20,
    marginBottom: 20,
    justifyContent: 'center',
    alignItems: 'stretch',
  },
  inputStyle: {
    borderWidth: 0.5,
    marginTop: 4,
    borderColor: '#999999',
    borderRadius: 5,
  },
  scrollViewContainerStyle: {
    flex: 1,
    alignItems: 'stretch',
    justifyContent: 'space-around',
  },
  label: {
    color: '#222',
  },
};
MessagesComposeScreen.propTypes = {
  dispatch: PropTypes.func,
  navigation: PropTypes.object,
  auth: PropTypes.object,
  messages: PropTypes.object,
};

const mapStateToProps = (state) => {
  return {
    userId: state.auth.user.id,
    group: state.auth.permissions.groups[0],
    messages: state.messages,
  };
};

const mapDispatchToProps = {messagesSendMessage, messagesGetAll};

export default connect(
  mapStateToProps,
  mapDispatchToProps,
)(MessagesComposeScreen);
