import React from 'react';
import {createDrawerNavigator} from 'react-navigation-drawer';
import {createStackNavigator} from 'react-navigation-stack';

import {Dimensions, Platform} from 'react-native';
import SideMenu from '../../components/SideMenu';
import DashboardScreen from './RouteScreen';
import ProfileScreen from './ProfileScreen';
import CompaniesScreen from './CompaniesScreen';
import MessagesScreen from './MessagesScreen';
import Icon from 'react-native-vector-icons/FontAwesome5';
import CompanyDetailScreen from './CompanyDetailScreen';
import MessageDetailScreen from './MessageDetailScreen';
import GroupScreen from './GroupScreen';
import SponsorsScreen from './SponsorsScreen';
import MessagesComposeScreen from './MessagesComposeScreen';
import FeedbackScreen from './FeedbackScreen';
import FeedbackDetailScreen from './FeedbackDetailScreen';
import BackToLoginScreen from './BackToLoginScreen';
import PublicCompaniesScreen from '../public/PublicCompaniesScreen';
import PublicCompanyDetailScreen from '../public/PublicCompanyDetailScreen';
import PublicOrganisationsScreen from '../public/PublicOrganisationsScreen';

const drawerOptions = {
  drawerWidth: () =>
    Dimensions.get('window').width - (Platform.OS === 'android' ? 56 : 64),
  contentOptions: {
    activeTintColor: 'rgb(66, 170, 230)',
    activeBackgroundColor: '#fff',
    inactiveTintColor: '#333',
    labelStyle: {fontSize: 16, marginVertical: 12, fontWeight: 'normal'},
    activeLabelStyle: {fontWeight: 'bold'},
  },
  initialRouteName: 'routeStack',
  contentComponent: SideMenu,
  drawerOpenRoute: 'DrawerOpen',
  drawerCloseRoute: 'DrawerClose',
  drawerToggleRoute: 'DrawerToggle',
};

// This navigator nests all screens for which a user has to be logged in.
// We use stacks to nest screens of different features. This gives the benefit of being easily extendable,
// back button behaviour and a topbar.
const SecuredNavigator = createDrawerNavigator(
  {
    routeStack: {
      screen: createStackNavigator({
        route: {
          screen: DashboardScreen,
          navigationOptions: {title: 'Jouw route'},
        },
        routeCompanyDetail: {
          screen: CompanyDetailScreen,
          navigationOptions: {title: 'Bedrijven'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Jouw route',
        drawerIcon: () => <Icon size={24} name={'route'} />,
      },
    },
    companiesStack: {
      screen: createStackNavigator({
        companies: {
          screen: CompaniesScreen,
          navigationOptions: {title: 'Bedrijven'},
        },
        companyDetail: {
          screen: CompanyDetailScreen,
          navigationOptions: {title: 'Bedrijven'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Bedrijven',
        drawerIcon: () => <Icon size={24} name={'building'} />,
      },
    },
    messagesStack: {
      screen: createStackNavigator({
        messages: {
          screen: MessagesScreen,
          navigationOptions: {title: 'Berichten'},
        },
        messagesCompose: {
          screen: MessagesComposeScreen,
          navigationOptions: {title: 'Bericht opstellen'},
        },
        messagesDetail: {
          screen: MessageDetailScreen,
          navigationOptions: {title: 'Berichten'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Berichten',
        drawerIcon: () => <Icon size={24} name={'envelope'} />,
      },
    },
    feedbackStack: {
      screen: createStackNavigator({
        feedback: {
          screen: FeedbackScreen,
          navigationOptions: {title: 'Feedback'},
        },
        feedbackDetail: {
          screen: FeedbackDetailScreen,
          navigationOptions: {title: 'Vragen beantwoorden'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Feedback',
        drawerIcon: () => <Icon size={24} name={'comment'} />,
      },
    },
    sponsorsStack: {
      screen: createStackNavigator({
        sponsors: {
          screen: SponsorsScreen,
          navigationOptions: {title: 'Sponsoren'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Sponsoren',
        drawerIcon: () => <Icon size={24} name={'handshake'} />,
      },
    },
    groupStack: {
      screen: createStackNavigator({
        group: {screen: GroupScreen, navigationOptions: {title: 'Jouw groep'}},
      }),
      navigationOptions: {
        drawerLabel: 'Jouw groep',
        drawerIcon: () => <Icon size={24} name={'users'} />,
      },
    },
    profileStack: {
      screen: createStackNavigator({
        profile: {
          screen: ProfileScreen,
          navigationOptions: {title: 'Jouw gegevens'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Jouw gegevens',
        drawerIcon: () => <Icon size={24} name={'cog'} />,
      },
    },
  },
  drawerOptions
);

export const NavigatorPublic = createDrawerNavigator(
  {
    companiesStack: {
      screen: createStackNavigator({
        organisations: {
          screen: PublicOrganisationsScreen,
          navigationOptions: {title: 'Gemeentes'},
        },
        companies: {
          screen: PublicCompaniesScreen,
          navigationOptions: {title: 'Bedrijven'},
        },
        companyDetail: {
          screen: PublicCompanyDetailScreen,
          navigationOptions: {title: 'Bedrijven'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Bedrijven',
        drawerIcon: () => <Icon size={24} name={'building'} />,
      },
    },
    sponsorsStack: {
      screen: createStackNavigator({
        sponsors: {
          screen: SponsorsScreen,
          navigationOptions: {title: 'Sponsoren'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Sponsoren',
        drawerIcon: () => <Icon size={24} name={'handshake'} />,
      },
    },
    backToLoginStack: {
      screen: createStackNavigator({
        backToLogin: {
          screen: BackToLoginScreen,
          navigationOptions: {title: 'Naar beginscherm'},
        },
      }),
      navigationOptions: {
        drawerLabel: 'Naar beginscherm',
        drawerIcon: () => <Icon size={24} name={'home'} />,
      },
    },
  },
  {...drawerOptions, initialRouteName: 'companiesStack'}
);

export default SecuredNavigator;
