import React from 'react';
import PropTypes from 'prop-types';
import {ScrollView, Image, Text, View, TouchableOpacity} from 'react-native';
import {Card} from 'react-native-elements';
import {connect} from 'react-redux';
import Screen from '../../components/Screen';
import {
  companiesGetById,
  companiesGetAllPublic,
  companiesSetShown,
  organisationsSetActiveSlug,
} from '../../shared/actions/companies';
import {bindActionCreators} from 'redux';

import LogoGemeenteOss from '../../assets/images/GEMEENTE_OSS.png';
import LogoGemeenteBernheze from '../../assets/images/BERNHEZE_LOGO.png';
import LogoTalentenCampus from '../../assets/images/TALENTENCAMPUSOSS.png';
import LogoJongerenOpWeg from '../../assets/images/JOWNB_LOGO_FC.png';
import LogoHooghuis from '../../assets/images/HHL_LOGO.png';
import LogoMaasland from '../../assets/images/MAASLANDCOLLEGE_LOGO.png';
import LogoLions from '../../assets/images/LIONS_LOGO.png';
import LogoInfraMensen from '../../assets/images/Logo_Inframensen_Zuid_CMYK.png';
import LogoBouwMensen from '../../assets/images/BOUWMENSEN_OSS_CMYK.png';
import LogoBouwkring from '../../assets/images/Logo_Bouwkring_BrabantNoordOost.png';
import LogoSchildersVakopleiding from '../../assets/images/SchildersVakopleiding.png';
import LogoOIK from '../../assets/images/OIK_CMYK.png';
import LogoIw from '../../assets/images/IW_Pay_off_CMYK.png';
import LogoNoa from '../../assets/images/NOA__contouren.png';
import LogoTibo from '../../assets/images/tibo.png';

class SponsorsScreen extends Screen {
  sponsors = [
    LogoGemeenteBernheze,
    LogoTalentenCampus,
    LogoJongerenOpWeg,
    LogoTibo,
    LogoHooghuis,
    LogoMaasland,
    LogoLions,
    LogoInfraMensen,
    LogoBouwMensen,
    LogoBouwkring,
    LogoSchildersVakopleiding,
    LogoOIK,
    LogoIw,
    LogoNoa,
  ];

  componentDidMount() {
    if (!this.props.mainSponsors[0]) {
      this.props.organisationsSetActiveSlug('oss');
      this.props.companiesGetAllPublic('oss');
    }
  }

  goToMainSponsor(index) {
    if (this.props.mainSponsors[index]) {
      this.props.companiesSetShown(this.props.mainSponsors[index], true);
    }
  }

  render() {
    return (
      <ScrollView style={{flex: 1}}>
        <View style={{marginBottom: 30}}>
          <Card style={{padding: 0, alignItems: 'center'}}>
            <Text>
              Wij werken met veel trots samen met de onderstaande organisaties
              om de Jongeren Bedrijvendag een groot succes te maken!
            </Text>
          </Card>
          <TouchableOpacity onPress={() => this.goToMainSponsor(0)}>
            <Card
              title={'Hoofdsponsor'}
              style={{padding: 0, alignItems: 'center'}}>
              <Image
                style={{flex: 1, height: 200, margin: 20}}
                resizeMode="contain"
                source={{
                  uri: 'https://cdn.jongerenbedrijvendag.nl/images/logos/45fa5532-b49d-4279-b34a-b9656d7f8350.jpg',
                }}
              />
              <Text
                style={{textAlign: 'center', fontWeight: 'bold', fontSize: 18}}>
                Rabobank Oss Bernheze
              </Text>
            </Card>
          </TouchableOpacity>
          <TouchableOpacity onPress={() => this.goToMainSponsor(1)}>
            <Card
              title={'Hoofdsponsor'}
              style={{padding: 0, alignItems: 'center'}}>
              <Image
                style={{flex: 1, maxHeight: 200, maxWidth: '90%', margin: 20}}
                resizeMode="contain"
                source={LogoGemeenteOss}
              />
              <Text
                style={{textAlign: 'center', fontWeight: 'bold', fontSize: 18}}>
                Gemeente Oss
              </Text>
            </Card>
          </TouchableOpacity>

          <Card
            title={'Sponsoren'}
            style={{padding: 10, paddingBottom: 30, alignItems: 'center'}}>
            {this.sponsors.map((s, index) => (
              <View
                key={index}
                style={{maxWidth: '90%', maxHeight: 200, margin: 20}}>
                <Image
                  style={{maxWidth: '90%', maxHeight: 200, margin: 20}}
                  resizeMode="contain"
                  source={s}
                />
              </View>
            ))}
          </Card>
        </View>
      </ScrollView>
    );
  }
}

SponsorsScreen.propTypes = {
  dispatch: PropTypes.func,
  navigation: PropTypes.object,
  auth: PropTypes.object,
};

const mapStateToProps = (state) => {
  return {
    auth: state.auth,
    companies: state.companies.list,
    mainSponsors: [
      state.companies.list.find(
        (c) => c.id === '139f605c-1013-4ef9-bb29-f124821fc0ec'
      ),
      state.companies.list.find(
        (c) => c.id === 'ed6bdcd0-0f38-4e56-9b98-fa0c9a8f6dcd'
      ),
    ],
  };
};

const mapDispatchToProps = (dispatch) => {
  return bindActionCreators(
    {
      companiesGetById,
      companiesGetAllPublic,
      organisationsSetActiveSlug,
      companiesSetShown,
    },
    dispatch
  );
};

export default connect(mapStateToProps, mapDispatchToProps)(SponsorsScreen);
