import {createStore, applyMiddleware, combineReducers, compose} from 'redux';
import thunk from 'redux-thunk';
import reducers from './shared/reducers';

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
const appReducer = combineReducers(reducers);

const store = createStore(
  appReducer /* preloadedState, */,
  composeEnhancers(applyMiddleware(thunk)),
);

export default store;