import axios from '../../axios-config';
import ConfigService from '../../ConfigService';
import store from '../../store';
import {NavigationActions} from '@react-navigation/core';
import NavigationService from '../services/NavigationService';

export const authCheckStatus = (authToken) => {
  return async (dispatch) => {
    // if (store.getState().auth.user) {
    //   if (store.getState().auth.user.username !== 'tst-0005') {
    //     NavigationService.navigate('app');
    //   }
    //   return;
    // }

    dispatch({
      type: 'AUTH_REQUEST',
      payload: {
        authToken,
      },
    });

    if (!authToken) {
      dispatch({
        type: 'AUTH_FAILED',
      });

      await ConfigService.remove('authToken');
      await ConfigService.remove('userId');

      NavigationService.navigate('login');
      return;
    }

    axios.defaults.headers.common.Authorization = 'Bearer ' + authToken.token;
    let authInfo = await axios.get('/auth/me');

    if (authInfo === undefined || authInfo.status !== 200) {
      dispatch({
        type: 'AUTH_FAILED',
      });

      await ConfigService.remove('userId');
      await ConfigService.remove('authToken');

      NavigationService.navigate('login');
      return;
    }

    let {user, permissions} = authInfo.data.data;
    if (
      user.username !== 'tst-0005' &&
      (!permissions.events[0] || !permissions.groups[0])
    ) {
      await ConfigService.remove('userId');
      await ConfigService.remove('authToken');

      return dispatch({
        type: 'AUTH_LOGIN_FAILED',
        payload: 'Er is geen evenement beschikbaar voor deze gebruiker.',
      });
    }

    dispatch({
      type: 'AUTH_SUCCESS',
      payload: {authToken, user, permissions},
    });
    if (user.username !== 'tst-0005') {
      NavigationService.navigate('app');
    } else {
      NavigationService.navigate('appPublic');
    }
  };
};

export const authLogin = (username, password) => {
  return async (dispatch) => {
    dispatch({
      type: 'AUTH_LOGGING_IN',
      payload: {
        username,
        password,
      },
    });

    let authInfo = await axios.post('/auth/token', {
      username,
      password,
    });

    if (authInfo.status !== 201) {
      return dispatch({
        type: 'AUTH_LOGIN_FAILED',
        payload: 'Inloggegevens incorrect.',
      });
    }

    let {authToken, user, permissions} = authInfo.data;
    if (
      user.username !== 'tst-0005' &&
      (!permissions.events[0] || !permissions.groups[0])
    ) {
      return dispatch({
        type: 'AUTH_LOGIN_FAILED',
        payload: 'Er is geen evenement beschikbaar voor deze gebruiker.',
      });
    }

    dispatch({
      type: 'AUTH_LOGIN_SUCCESS',
      payload: {
        authToken,
        user,
        permissions,
      },
    });

    if (user.username !== 'tst-0005') {
      await ConfigService.set('authToken', authToken);
      await ConfigService.set('userId', user.id);

      NavigationService.navigate('app');
    } else {
      NavigationService.navigate('appPublic');
    }
  };
};

export const authLogout = () => {
  return async (dispatch) => {
    dispatch({
      type: 'AUTH_LOGGING_OUT',
    });

    const state = store.getState().auth;

    if (!state.authToken) {
      dispatch({
        type: 'AUTH_LOGOUT_SUCCESS',
      });

      await ConfigService.remove('authToken');
      await ConfigService.remove('userId');

      return NavigationActions.navigate('login');
    }

    await axios.delete('/auth/token');

    dispatch({
      type: 'AUTH_LOGOUT_SUCCESS',
    });

    await ConfigService.remove('authToken');
    await ConfigService.remove('userId');

    NavigationService.navigate('login');
  };
};

export const authSetPushNotificationToken = (pushNotificationToken) => {
  return async () => {
    const authToken = await ConfigService.get('authToken');
    const userId = await ConfigService.get('userId');
    if (authToken) {
      axios.defaults.headers.common.Authorization = 'Bearer ' + authToken;
      axios
        .post(`/users/${userId}/push-tokens`, {
          token: pushNotificationToken,
        })
        .catch(() => {
          _authUnknownError();
        });
    }
  };
};

export const authDeletePushNotificationToken = (pushNotificationToken) => {
  return async () => {
    const authToken = await ConfigService.get('authToken');
    const userId = await ConfigService.get('userId');
    if (authToken) {
      axios.defaults.headers.common.Authorization = 'Bearer ' + authToken;
      axios
        .delete(
          `/users/${userId}/push-tokens/${encodeURIComponent(
            pushNotificationToken,
          )}`,
        )
        .catch(() => {
          _authUnknownError();
        });
    }
  };
};

const _authUnknownError = () => {
  return async (dispatch) => {
    dispatch({type: 'AUTH_LOGIN_FAILED'});
  };
};
