import axios from '../../axios-config';

export const categoriesGetAllPublic = (organisationSlug) => {
  return async (dispatch) => {
    let organisationsResponse = await axios.get('/public/organisations');
    let organisation = organisationsResponse.data.data.find(
      (org) => org.slug === organisationSlug
    );
    let categories = organisation.categories;

    dispatch({
      type: 'CATEGORIES_GET_ALL',
      payload: {categories},
    });
  };
};

export const categoriesGetAll = (organisationId) => {
  return async (dispatch) => {
    let categoriesResponse = await axios.get(
      `/organisations/${organisationId}/categories`
    );
    let categories = categoriesResponse.data.data;

    dispatch({
      type: 'CATEGORIES_GET_ALL',
      payload: {categories},
    });
  };
};
