import axios from '../../axios-config';
import NavigationService from '../services/NavigationService';

export const organisationsSetActiveSlug = (organisationSlug) => {
  return async (dispatch) => {
    dispatch({
      type: 'ORGANISATIONS_SET_ACTIVE',
      payload: {organisationSlug},
    });
  };
};

export const companiesGetAllPublic = (organisationSlug) => {
  return async (dispatch) => {
    dispatch({type: 'COMPANIES_GETTING'});
    const companiesResponse = await axios.get(
      `/public/organisations/${organisationSlug}/companies`
    );
    let companies = companiesResponse.data.data;
    // const sponsorsResponse = await axios.get(
    //   `/organisations/${organisationId}/events/${eventId}/sponsors`
    // );
    // const sponsors = sponsorsResponse.data.data;
    // sponsors.forEach((sponsor) => {
    //   companies.find((company) => company.id === sponsor.id).isSponsor = true;
    // });

    // companies = companies.sort((a, b) => {
    //   if (a.isSponsor && !b.isSponsor) {
    //     return -1;
    //   } else if (b.isSponsor && !a.isSponsor) {
    //     return 1;
    //   }
    //   return 0;
    // });

    dispatch({
      type: 'COMPANIES_SET_ALL',
      payload: {companies, sponsors: []},
    });
  };
};

export const companiesGetAll = (organisationId, eventId) => {
  return async (dispatch) => {
    dispatch({type: 'COMPANIES_GETTING'});
    const companiesResponse = await axios.get(
      `/organisations/${organisationId}/events/${eventId}/companies`
    );
    let companies = companiesResponse.data.data;
    const sponsorsResponse = await axios.get(
      `/organisations/${organisationId}/events/${eventId}/sponsors`
    );
    const sponsors = sponsorsResponse.data.data;
    sponsors.forEach((sponsor) => {
      companies.find((company) => company.id === sponsor.id).isSponsor = true;
    });

    companies = companies.sort((a, b) => {
      if (a.isSponsor && !b.isSponsor) {
        return -1;
      } else if (b.isSponsor && !a.isSponsor) {
        return 1;
      }
      return 0;
    });

    dispatch({
      type: 'COMPANIES_SET_ALL',
      payload: {companies, sponsors},
    });
  };
};

export const companiesGetById = (organisationId, eventId, companyId) => {
  return async (dispatch, getState) => {
    let companyResponse = await axios.get(
      `/organisations/${organisationId}/events/${eventId}/companies/${companyId}`
    );
    let company = companyResponse.data.data;

    getState().companies.sponsors.forEach((sponsor) => {
      if (company.id === sponsor.id) {
        company.isSponsor = true;
      }
    });

    dispatch({
      type: 'COMPANIES_SET_SINGLE',
      payload: {id: companyId, company},
    });
  };
};

export const companiesGetByIdPublic = (organisationSlug, companyId) => {
  return async (dispatch, getState) => {
    let companyResponse = await axios.get(
      `/public/organisations/${organisationSlug}/companies/${companyId}`
    );
    let company = companyResponse.data.data;

    getState().companies.sponsors.forEach((sponsor) => {
      if (company.id === sponsor.id) {
        company.isSponsor = true;
      }
    });

    dispatch({
      type: 'COMPANIES_SET_SINGLE',
      payload: {id: companyId, company},
    });
  };
};

export const companiesSetShown = (
  company,
  navigate = false,
  route = 'companyDetail'
) => {
  return (dispatch) => {
    dispatch({
      type: 'COMPANIES_SET_SHOWN',
      payload: {company},
    });
    if (navigate) {
      NavigationService.navigate(route, {isDetail: true});
    }
  };
};
